/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.client;

import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionManager;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionTAC;
import com.github.tartaricacid.touhoulittlemaid.client.entity.GeckoMaidEntity;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.SWarfareCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.PlayState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.AnimationBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.file.AnimationFile;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class GunGeckoAnimation {
    public static PlayState playGrenadeAnimation(AnimationEvent<GeckoMaidEntity<?>> event, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return GunGeckoAnimation.playLoopAnimation(event, "tac:mainhand:grenade");
        }
        return GunGeckoAnimation.playLoopAnimation(event, "tac:offhand:grenade");
    }

    public static PlayState playGunMainAnimation(AnimationEvent<GeckoMaidEntity<?>> event, String animationName, ILoopType loopType) {
        String tacName = "tac:" + animationName;
        GeckoMaidEntity<?> animatable = event.getAnimatableEntity();
        class_2960 animation = animatable.getAnimationFileLocation();
        AnimationFile animationFile = GeckoLibCache.getInstance().getAnimations().get(animation);
        if (!GunGeckoAnimation.isMaidCarrying(animatable.getMaid()) && animationFile.animations().containsKey(tacName)) {
            return GunGeckoAnimation.playAnimation(event, tacName, loopType);
        }
        return GunGeckoAnimation.playAnimation(event, animationName, loopType);
    }

    public static PlayState playGunHoldAnimation(AnimationEvent<GeckoMaidEntity<?>> event, class_1799 heldItem) {
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (GunGeckoAnimation.isMaidCarrying(maid)) {
            return PlayState.STOP;
        }
        class_1308 entity = maid.asEntity();
        if (!(heldItem.method_7909() instanceof GunItem)) {
            return null;
        }
        if (!entity.method_5681() && entity.method_18376() == class_4050.field_18079) {
            if ((double)Math.abs(event.getLimbSwingAmount()) > 0.05) {
                return GunGeckoAnimation.getGunTypeAnimation(event, heldItem, "tac:climb:");
            }
            return GunGeckoAnimation.getGunTypeAnimation(event, heldItem, "tac:climbing:");
        }
        boolean isAim = false;
        if (entity instanceof EntityMaid) {
            long time;
            EntityMaid maidEntity = (EntityMaid)entity;
            isAim = maidEntity.isAiming();
            if (maidEntity.animationId == 3) {
                time = System.currentTimeMillis() - maidEntity.animationRecordTime;
                if (time < 2500L) {
                    if (maidEntity.shouldReset) {
                        maidEntity.shouldReset = false;
                        event.getController().shouldResetTick = true;
                        event.getController().adjustTick(0.0);
                    }
                    return GunGeckoAnimation.getGunTypeAnimation(event, heldItem, "tac:reload:");
                }
                maidEntity.animationId = 0;
                maidEntity.animationRecordTime = -1L;
            }
            if (maidEntity.animationId == 4) {
                time = System.currentTimeMillis() - maidEntity.animationRecordTime;
                if (time < 100L) {
                    if (maidEntity.shouldReset) {
                        maidEntity.shouldReset = false;
                        event.getController().shouldResetTick = true;
                        event.getController().adjustTick(0.0);
                    }
                    if (isAim) {
                        return GunGeckoAnimation.getGunTypeAnimation(event, heldItem, "tac:aim:fire:");
                    }
                    return GunGeckoAnimation.getGunTypeAnimation(event, heldItem, "tac:hold:fire:");
                }
                maidEntity.animationId = 0;
                maidEntity.animationRecordTime = -1L;
            }
        }
        if (entity.method_24828() && entity.method_5624()) {
            return GunGeckoAnimation.getGunTypeAnimation(event, heldItem, "tac:run:");
        }
        if (isAim) {
            return GunGeckoAnimation.getGunTypeAnimation(event, heldItem, "tac:aim:");
        }
        return GunGeckoAnimation.getGunTypeAnimation(event, heldItem, "tac:hold:");
    }

    @NotNull
    private static PlayState getGunTypeAnimation(AnimationEvent<GeckoMaidEntity<?>> event, class_1799 gun, String prefix) {
        class_2960 modelId = event.getAnimatableEntity().getAnimationFileLocation();
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        class_1308 entity = maid.asEntity();
        ConditionTAC condition = ConditionManager.getTAC(modelId);
        if (condition != null) {
            class_1799 stack = entity.method_6047();
            String name = condition.doTest(stack, prefix);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
                return GunGeckoAnimation.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        if (gun.method_31573(SWarfareCompat.PISTOL)) {
            return GunGeckoAnimation.playLoopAnimation(event, prefix + "pistol");
        }
        if (gun.method_31573(SWarfareCompat.RPG)) {
            return GunGeckoAnimation.playLoopAnimation(event, prefix + "rpg");
        }
        return GunGeckoAnimation.playLoopAnimation(event, prefix + "rifle");
    }

    @NotNull
    private static PlayState playLoopAnimation(AnimationEvent<?> event, String animationName) {
        return GunGeckoAnimation.playAnimation(event, animationName, ILoopType.EDefaultLoopTypes.LOOP);
    }

    @NotNull
    private static PlayState playAnimation(AnimationEvent<?> event, String animationName, ILoopType loopType) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName, loopType));
        return PlayState.CONTINUE;
    }

    private static boolean isMaidCarrying(IMaid maid) {
        class_1308 entity = maid.asEntity();
        return entity.method_5854() instanceof class_1657;
    }
}

