/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBox;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFilm;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3956;
import net.minecraft.class_5425;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import org.jetbrains.annotations.NotNull;

public class AltarRecipe
extends class_1867 {
    private final String group;
    private final class_7710 category;
    private final float power;
    private final class_1799 result;
    private final class_2960 entityType;
    private final String langKey;

    public AltarRecipe(String group, class_7710 category, class_2371<class_1856> ingredients, float power, class_1799 result, class_2960 entityType, String langKey) {
        super(group, category, result, ingredients);
        this.group = group;
        this.category = category;
        this.power = power;
        this.result = result;
        this.entityType = entityType;
        this.langKey = langKey;
    }

    public class_2960 getId() {
        return class_7923.field_41188.method_10221(InitRecipes.ALTAR_CRAFTING);
    }

    public String getRecipeString() {
        String recipeId = (String)this.result.method_57824(InitDataComponent.RECIPES_ID_TAG);
        return Objects.requireNonNullElse(recipeId, "spawn_box");
    }

    public boolean isItemCraft() {
        return this.entityType.equals((Object)class_7923.field_41177.method_10221((Object)class_1299.field_6052));
    }

    public void spawnOutputEntity(class_3218 world, class_2338 pos, @Nullable List<class_1799> list) {
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(this.entityType);
        if (type == class_1299.field_6052) {
            this.spawnItem(world, pos);
            return;
        }
        if (type == InitEntities.BOX) {
            this.spawnBoxMaid(world, pos);
            return;
        }
        if (type == InitEntities.MAID) {
            this.rebornMaid(world, pos, list);
            return;
        }
        type.method_47821(world, pos, class_3730.field_16467);
    }

    private void rebornMaid(class_3218 world, class_2338 pos, @Nullable List<class_1799> list) {
        class_1799 itemFilm = class_1799.field_8037;
        if (list != null) {
            itemFilm = list.stream().filter(stack -> stack.method_7909() instanceof ItemFilm).findFirst().orElse(class_1799.field_8037);
        }
        EntityMaid maid = new EntityMaid((class_1937)world);
        class_9279 compoundData = (class_9279)itemFilm.method_57824(InitDataComponent.MAID_INFO);
        if (compoundData != null) {
            class_2487 maidCompound = compoundData.method_57461();
            maid.method_5749(maidCompound);
        } else {
            maid.method_5943((class_5425)world, world.method_8404(pos), class_3730.field_16465, null);
        }
        maid.method_5814(pos.method_10263(), pos.method_10264(), pos.method_10260());
        world.method_8649((class_1297)maid);
    }

    private void spawnBoxMaid(class_3218 world, class_2338 pos) {
        EntityBox box = new EntityBox((class_1937)world);
        box.method_5814(pos.method_10263(), pos.method_10264(), pos.method_10260());
        EntityMaid maid = new EntityMaid((class_1937)world);
        maid.method_5814(pos.method_10263(), pos.method_10264(), pos.method_10260());
        maid.method_5943((class_5425)world, world.method_8404(pos), class_3730.field_16465, null);
        maid.method_5873(box, true);
        world.method_30736((class_1297)box);
    }

    private void spawnItem(class_3218 world, class_2338 pos) {
        class_1542 itemEntity = new class_1542((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), this.result.method_7972());
        world.method_8649((class_1297)itemEntity);
    }

    @NotNull
    public class_3956<?> method_17716() {
        return InitRecipes.ALTAR_CRAFTING;
    }

    public class_1865<?> method_8119() {
        return InitRecipes.ALTAR_RECIPE_SERIALIZER;
    }

    public float getPower() {
        return this.power;
    }

    public String method_8112() {
        return this.group;
    }

    public class_7710 getCategory() {
        return this.category;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public class_2960 getEntityType() {
        return this.entityType;
    }

    public String getLangKey() {
        return this.langKey;
    }
}

