/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain;

import com.github.tartaricacid.touhoulittlemaid.api.entity.ai.IExtraMaidBrain;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.ExtraMaidBrainManager;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.ride.MaidRideBegTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAwaitTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBegTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBreathAirStopTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBreathAirTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidClearHurtTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidClearSleepTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidClimbTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFindHomeMealTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFollowOwnerTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFollowOwnerVehicleTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidHealSelfTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidHomeMealTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidInteractWithDoor;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidJoyTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidPanicTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidPickupEntitiesTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRunAwayTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRunOne;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidSwimJumpTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUpdateActivityFromSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidWorkMealTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4119;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4818;
import net.minecraft.class_7893;

public final class MaidBrain {
    public static ImmutableList<class_4140<?>> getMemoryTypes() {
        ArrayList defaultTypes = Lists.newArrayList((Object[])new class_4140[]{class_4140.field_18449, class_4140.field_26389, class_4140.field_18446, class_4140.field_18453, class_4140.field_18451, class_4140.field_18452, class_4140.field_19293, class_4140.field_18445, class_4140.field_22355, class_4140.field_22475, InitEntities.TARGET_POS});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> defaultTypes.addAll(extra.getExtraMemoryTypes()));
        return ImmutableList.copyOf((Collection)defaultTypes);
    }

    public static ImmutableList<class_4149<? extends class_4148<? super EntityMaid>>> getSensorTypes() {
        ArrayList defaultTypes = Lists.newArrayList((Object[])new class_4149[]{InitEntities.MAID_NEAREST_LIVING_ENTITY_SENSOR, class_4149.field_18469, InitEntities.MAID_HOSTILES_SENSOR, InitEntities.MAID_PICKUP_ENTITIES_SENSOR});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> defaultTypes.addAll(extra.getExtraSensorTypes()));
        return ImmutableList.copyOf((Collection)defaultTypes);
    }

    public static void registerBrainGoals(class_4095<EntityMaid> brain, EntityMaid maid) {
        MaidBrain.registerSchedule(brain, maid);
        MaidBrain.registerCoreGoals(brain);
        MaidBrain.registerPanicGoals(brain);
        MaidBrain.registerRideIdleGoals(brain);
        MaidBrain.registerRideWorkGoals(brain, maid);
        MaidBrain.registerRideRestGoals(brain);
        MaidBrain.registerIdleGoals(brain);
        MaidBrain.registerWorkGoals(brain, maid);
        MaidBrain.registerRestGoals(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24526(class_4168.field_18595);
        MaidUpdateActivityFromSchedule.updateActivityFromSchedule(maid, brain);
    }

    private static void registerSchedule(class_4095<EntityMaid> brain, EntityMaid maid) {
        switch (maid.getSchedule()) {
            case ALL: {
                brain.method_18884(InitEntities.MAID_ALL_DAY_SCHEDULES);
                break;
            }
            case NIGHT: {
                brain.method_18884(InitEntities.MAID_NIGHT_SHIFT_SCHEDULES);
                break;
            }
            default: {
                brain.method_18884(InitEntities.MAID_DAY_SHIFT_SCHEDULES);
            }
        }
    }

    private static void registerCoreGoals(class_4095<EntityMaid> brain) {
        Pair swimJump = Pair.of((Object)0, (Object)((Object)new MaidSwimJumpTask(0.8f)));
        Pair breathAir = Pair.of((Object)0, (Object)((Object)new MaidBreathAirTask()));
        Pair breathAirStop = Pair.of((Object)0, (Object)((Object)new MaidBreathAirStopTask()));
        Pair climb = Pair.of((Object)0, (Object)((Object)new MaidClimbTask()));
        Pair look = Pair.of((Object)0, (Object)new class_4110(45, 90));
        Pair maidPanic = Pair.of((Object)1, (Object)((Object)new MaidPanicTask()));
        Pair maidAwait = Pair.of((Object)1, (Object)((Object)new MaidAwaitTask()));
        Pair interactWithDoor = Pair.of((Object)2, MaidInteractWithDoor.create());
        Pair walkToTarget = Pair.of((Object)2, (Object)new class_4112());
        Pair followOwner = Pair.of((Object)3, (Object)((Object)new MaidFollowOwnerTask(0.5f, 2)));
        Pair followOwnerVehicle = Pair.of((Object)3, (Object)((Object)new MaidFollowOwnerVehicleTask(0.5f, 2)));
        Pair healSelf = Pair.of((Object)3, (Object)((Object)new MaidHealSelfTask()));
        Pair pickupItem = Pair.of((Object)10, (Object)((Object)new MaidPickupEntitiesTask(EntityMaid::isPickup, 0.6f)));
        Pair clearSleep = Pair.of((Object)99, (Object)((Object)new MaidClearSleepTask()));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{swimJump, climb, breathAir, breathAirStop, look, maidPanic, maidAwait, interactWithDoor, walkToTarget, followOwner, followOwnerVehicle, healSelf, pickupItem, clearSleep});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getCoreBehaviors()));
        brain.method_18881(class_4168.field_18594, ImmutableList.copyOf((Collection)behaviors));
    }

    private static void registerIdleGoals(class_4095<EntityMaid> brain) {
        Pair beg = Pair.of((Object)5, (Object)((Object)new MaidBegTask()));
        Pair homeMeal = Pair.of((Object)6, (Object)((Object)new MaidFindHomeMealTask(0.6f, 2)));
        Pair joy = Pair.of((Object)7, (Object)((Object)new MaidJoyTask(0.6f, 2)));
        Pair supplemented = Pair.of((Object)20, (Object)((Object)MaidBrain.getLookAndRandomWalk(maid -> !maid.getSwimManager().isGoingToBreath())));
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{beg, homeMeal, joy, supplemented, updateActivity});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getIdleBehaviors()));
        brain.method_18881(class_4168.field_18595, ImmutableList.copyOf((Collection)behaviors));
    }

    private static void registerWorkGoals(class_4095<EntityMaid> brain, EntityMaid maid) {
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        IMaidTask task = maid.getTask();
        ArrayList pairMaidList = task.createBrainTasks(maid);
        if (pairMaidList.isEmpty()) {
            pairMaidList = Lists.newArrayList((Object[])new Pair[]{updateActivity});
        } else {
            pairMaidList.add((Pair<Integer, class_7893<? super EntityMaid>>)updateActivity);
        }
        pairMaidList.add(Pair.of((Object)6, (Object)((Object)new MaidBegTask())));
        pairMaidList.add(Pair.of((Object)7, (Object)((Object)new MaidWorkMealTask())));
        pairMaidList.add(Pair.of((Object)20, (Object)((Object)MaidBrain.getLookAndRandomWalk(e -> e.getTask().enableLookAndRandomWalk((EntityMaid)e) && !e.getSwimManager().isGoingToBreath()))));
        for (IExtraMaidBrain extra : ExtraMaidBrainManager.EXTRA_MAID_BRAINS) {
            pairMaidList.addAll(extra.getWorkBehaviors());
        }
        brain.method_18881(class_4168.field_18596, ImmutableList.copyOf((Collection)pairMaidList));
    }

    private static void registerRestGoals(class_4095<EntityMaid> brain) {
        Pair bed = Pair.of((Object)5, (Object)((Object)new MaidBedTask(0.6f, 2)));
        Pair supplemented = Pair.of((Object)20, (Object)((Object)MaidBrain.getLookAndRandomWalk(maid -> true)));
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{bed, supplemented, updateActivity});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getRestBehaviors()));
        brain.method_18881(class_4168.field_18597, ImmutableList.copyOf((Collection)behaviors));
    }

    private static void registerPanicGoals(class_4095<EntityMaid> brain) {
        Pair clearHurt = Pair.of((Object)5, (Object)((Object)new MaidClearHurtTask()));
        Pair runAway = Pair.of((Object)5, MaidRunAwayTask.entity((class_4140<? extends class_1297>)class_4140.field_18453, 0.7f, false));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{clearHurt, runAway});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getPanicBehaviors()));
        brain.method_18881(class_4168.field_18599, ImmutableList.copyOf((Collection)behaviors));
    }

    private static void registerRideIdleGoals(class_4095<EntityMaid> brain) {
        Pair beg = Pair.of((Object)4, (Object)((Object)new MaidRideBegTask()));
        Pair homeMeal = Pair.of((Object)5, (Object)((Object)new MaidHomeMealTask()));
        Pair look = Pair.of((Object)6, (Object)((Object)MaidBrain.getLook(maid -> true)));
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{beg, homeMeal, look, updateActivity});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getRideIdleBehaviors()));
        brain.method_18881(InitEntities.RIDE_IDLE, ImmutableList.copyOf((Collection)behaviors));
    }

    private static void registerRideWorkGoals(class_4095<EntityMaid> brain, EntityMaid maid) {
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        IMaidTask task = maid.getTask();
        ArrayList pairMaidList = task.createRideBrainTasks(maid);
        if (pairMaidList.isEmpty()) {
            pairMaidList = Lists.newArrayList((Object[])new Pair[]{updateActivity});
        } else {
            pairMaidList.add((Pair<Integer, class_7893<? super EntityMaid>>)updateActivity);
        }
        pairMaidList.add(Pair.of((Object)6, (Object)((Object)new MaidRideBegTask())));
        pairMaidList.add(Pair.of((Object)7, (Object)((Object)new MaidWorkMealTask())));
        pairMaidList.add(Pair.of((Object)20, (Object)((Object)MaidBrain.getLook(e -> e.getTask().enableLookAndRandomWalk((EntityMaid)e)))));
        for (IExtraMaidBrain extra : ExtraMaidBrainManager.EXTRA_MAID_BRAINS) {
            pairMaidList.addAll(extra.getRideWorkBehaviors());
        }
        brain.method_18881(InitEntities.RIDE_WORK, ImmutableList.copyOf((Collection)pairMaidList));
    }

    private static void registerRideRestGoals(class_4095<EntityMaid> brain) {
        Pair updateActivity = Pair.of((Object)99, (Object)((Object)new MaidUpdateActivityFromSchedule()));
        ArrayList behaviors = Lists.newArrayList((Object[])new Pair[]{updateActivity});
        ExtraMaidBrainManager.EXTRA_MAID_BRAINS.forEach(extra -> behaviors.addAll(extra.getRideRestBehaviors()));
        brain.method_18881(InitEntities.RIDE_REST, ImmutableList.copyOf((Collection)behaviors));
    }

    private static MaidRunOne getLookAndRandomWalk(Predicate<EntityMaid> enableCondition) {
        Pair lookToPlayer = Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)5.0f), (Object)1);
        Pair lookToMaid = Pair.of((Object)class_4119.method_47057(EntityMaid.TYPE, (float)5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6055, (float)5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_16281, (float)5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6104, (float)5.0f), (Object)1);
        Pair walkRandomly = Pair.of((Object)class_4818.method_47015((float)0.3f, (int)5, (int)3), (Object)1);
        Pair noLook = Pair.of((Object)new class_4101(30, 60), (Object)2);
        return new MaidRunOne((List<Pair<? extends class_7893<? super EntityMaid>, Integer>>)ImmutableList.of((Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)walkRandomly, (Object)noLook), enableCondition);
    }

    private static MaidRunOne getLook(Predicate<EntityMaid> enableCondition) {
        Pair lookToPlayer = Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)5.0f), (Object)1);
        Pair lookToMaid = Pair.of((Object)class_4119.method_47057(EntityMaid.TYPE, (float)5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6055, (float)5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_16281, (float)5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6104, (float)5.0f), (Object)1);
        Pair noLook = Pair.of((Object)new class_4101(30, 60), (Object)2);
        return new MaidRunOne((List<Pair<? extends class_7893<? super EntityMaid>, Integer>>)ImmutableList.of((Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)noLook), enableCondition);
    }
}

