/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.data;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.data.TaskDataRegister;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaidTaskDataMaps {
    private static final String TAG_NAME = "MaidTaskDataMaps";
    private final Reference2ObjectMap<TaskDataKey<?>, Optional<?>> dataMaps = new Reference2ObjectOpenHashMap();

    @Nullable
    public <T> T getData(TaskDataKey<T> dataKey) {
        Optional optional = (Optional)this.dataMaps.get(dataKey);
        if (optional != null && optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public <T> T getOrCreateData(TaskDataKey<T> dataKey, T defaultValue) {
        T data;
        if (this.dataMaps.containsKey(dataKey) && (data = this.getData(dataKey)) != null) {
            return data;
        }
        this.dataMaps.put(dataKey, Optional.of(defaultValue));
        return defaultValue;
    }

    public <T> void setData(TaskDataKey<?> dataKey, T value) {
        this.dataMaps.put(dataKey, Optional.of(value));
    }

    public void writeSaveData(class_2487 entityTag) {
        class_2487 dataTags = this.readOrCreateTag(entityTag);
        this.dataMaps.forEach((key, value) -> {
            TaskDataKey dataKey = key;
            value.ifPresent(data -> {
                class_2487 saveData = dataKey.writeSaveData(data);
                dataTags.method_10566(key.getKey().toString(), (class_2520)saveData);
            });
        });
    }

    public void readSaveData(class_2487 entityTag) {
        this.dataMaps.clear();
        class_2487 dataTags = this.readOrCreateTag(entityTag);
        for (String key : dataTags.method_10541()) {
            TaskDataKey dataKey = TaskDataRegister.getValue(class_2960.method_60654((String)key));
            if (dataKey == null) continue;
            class_2487 tag = dataTags.method_10562(key);
            this.dataMaps.put(dataKey, Optional.of(dataKey.readSaveData(tag)));
        }
    }

    public class_2487 getUpdateTag() {
        class_2487 taskTags = new class_2487();
        this.dataMaps.forEach((key, value) -> {
            TaskDataKey dataKey = key;
            value.ifPresent(data -> {
                class_2487 syncData = dataKey.writeSyncData(data);
                taskTags.method_10566(key.getKey().toString(), (class_2520)syncData);
            });
        });
        return taskTags;
    }

    @Environment(value=EnvType.CLIENT)
    public void readFromServer(class_2487 taskTags) {
        this.dataMaps.clear();
        for (String key : taskTags.method_10541()) {
            TaskDataKey dataKey = TaskDataRegister.getValue(class_2960.method_60654((String)key));
            if (dataKey == null) continue;
            class_2487 tag = taskTags.method_10562(key);
            this.dataMaps.put(dataKey, Optional.of(dataKey.readSyncData(tag)));
        }
    }

    @NotNull
    private class_2487 readOrCreateTag(class_2487 entityTag) {
        if (entityTag.method_10545(TAG_NAME)) {
            return entityTag.method_10562(TAG_NAME);
        }
        class_2487 dataTags = new class_2487();
        entityTag.method_10566(TAG_NAME, (class_2520)dataTags);
        return dataTags;
    }
}

