/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position;
import com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Search;
import com.github.tartaricacid.touhoulittlemaid.network.message.CChessToServerPackage;
import com.github.tartaricacid.touhoulittlemaid.util.CChessUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record CChessToClientPackage(class_2338 pos, String fenData) implements class_8710
{
    public static final class_8710.class_9154<CChessToClientPackage> TYPE = new class_8710.class_9154(ResourceLocationUtil.getResourceLocation("cchess_to_client"));
    public static final class_9139<ByteBuf, CChessToClientPackage> STREAM_CODEC = class_9139.method_56435((class_9139)class_2338.field_48404, CChessToClientPackage::pos, (class_9139)class_9135.field_48554, CChessToClientPackage::fenData, CChessToClientPackage::new);

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(CChessToClientPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> CompletableFuture.runAsync(() -> CChessToClientPackage.onHandle(message), class_156.method_18349()));
    }

    @Environment(value=EnvType.CLIENT)
    private static void onHandle(CChessToClientPackage message) {
        int levelTime = 1000;
        long timeStart = System.currentTimeMillis();
        int move = 0;
        Position position = new Position();
        position.fromFen(message.fenData);
        boolean maidLost = CChessUtil.isMaid(position) && position.isMate();
        boolean playerLost = false;
        if (!maidLost) {
            move = new Search(position, 12).searchMain(levelTime);
            playerLost = position.makeMove(move) && CChessUtil.isPlayer(position) && position.isMate();
        }
        long timeRemain = Math.max(0, levelTime - (int)(System.currentTimeMillis() - timeStart));
        try {
            if (timeRemain > 0L) {
                Thread.sleep(timeRemain);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        int moveFinal = move;
        boolean playerLostFinal = playerLost;
        class_310.method_1551().method_5382(() -> ClientPlayNetworking.send((class_8710)new CChessToServerPackage(message.pos, moveFinal, maidLost, playerLostFinal)));
    }
}

