/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSystemServices;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public record TTSSystemAudioToClientPackage(String siteName, String chatText, TTSConfig config, TTSSystemServices services) implements class_8710
{
    public static final class_8710.class_9154<TTSSystemAudioToClientPackage> TYPE = new class_8710.class_9154(ResourceLocationUtil.getResourceLocation("tts_system_audio_to_client"));
    public static final class_9139<ByteBuf, TTSSystemAudioToClientPackage> STREAM_CODEC = new class_9139<ByteBuf, TTSSystemAudioToClientPackage>(){

        public TTSSystemAudioToClientPackage decode(ByteBuf byteBuf) {
            class_2540 buf = new class_2540(byteBuf);
            String siteName = buf.method_19772();
            TTSSite ttsSite = AvailableSites.getTTSSite(siteName);
            TTSClient tTSClient = ttsSite.client();
            if (tTSClient instanceof TTSSystemServices) {
                TTSSystemServices services = (TTSSystemServices)((Object)tTSClient);
                Pair<String, TTSConfig> pair = services.readFromNetwork(buf);
                return new TTSSystemAudioToClientPackage(siteName, (String)pair.getLeft(), (TTSConfig)pair.getRight(), services);
            }
            throw new IllegalArgumentException("Invalid TTS site: " + siteName);
        }

        public void encode(ByteBuf byteBuf, TTSSystemAudioToClientPackage message) {
            class_2540 buf = new class_2540(byteBuf);
            buf.method_10814(message.siteName);
            message.services.writeToNetwork(message.chatText, message.config, buf);
        }
    };

    public static void handle(TTSSystemAudioToClientPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> TTSSystemAudioToClientPackage.onHandle(message));
    }

    @Environment(value=EnvType.CLIENT)
    private static void onHandle(TTSSystemAudioToClientPackage message) {
        TTSSite ttsSite = AvailableSites.getTTSSite(message.siteName);
        if (ttsSite == null || !ttsSite.enabled()) {
            return;
        }
        ttsSite.client().play(message.chatText, message.config, null);
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

