/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.bedrock.model;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockCube;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class BedrockPart {
    private static final Vector3f[] NORMALS = new Vector3f[6];
    private static final int MAX_LIGHT_TEXTURE = class_765.method_23687((int)15, (int)15);
    public final ObjectList<BedrockCube> cubes = new ObjectArrayList();
    public final ObjectList<BedrockPart> children = new ObjectArrayList();
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;
    public float initRotX = 0.0f;
    public float initRotY = 0.0f;
    public float initRotZ = 0.0f;
    public float xRot = 0.0f;
    public float yRot = 0.0f;
    public float zRot = 0.0f;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public float offsetZ = 0.0f;
    public float xScale = 1.0f;
    public float yScale = 1.0f;
    public float zScale = 1.0f;
    public Quaternionf additionalQuaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    @Nullable
    public BedrockPart parent = null;
    public boolean visible = true;
    public boolean illuminated = false;
    public boolean mirror = false;

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void render(class_4587 poseStack, class_4588 consumer, int lightmap, int overlay) {
        this.render(poseStack, consumer, lightmap, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(class_4587 poseStack, class_4588 consumer, int lightmap, int overlay, float red, float green, float blue, float alpha) {
        int cubePackedLight;
        int n = cubePackedLight = this.illuminated ? MAX_LIGHT_TEXTURE : lightmap;
        if (this.visible) {
            boolean zNearZero;
            boolean xNearZero = -1.0E-5f < this.xScale && this.xScale < 1.0E-5f;
            boolean yNearZero = -1.0E-5f < this.yScale && this.yScale < 1.0E-5f;
            boolean bl = zNearZero = -1.0E-5f < this.zScale && this.zScale < 1.0E-5f;
            if (xNearZero && yNearZero || xNearZero && zNearZero || yNearZero && zNearZero) {
                return;
            }
            if (!this.cubes.isEmpty() || !this.children.isEmpty()) {
                poseStack.method_22903();
                this.translateAndRotateAndScale(poseStack);
                this.compile(poseStack.method_23760(), consumer, cubePackedLight, overlay, red, green, blue, alpha);
                for (BedrockPart part : this.children) {
                    part.render(poseStack, consumer, cubePackedLight, overlay, red, green, blue, alpha);
                }
                poseStack.method_22909();
            }
        }
    }

    @Deprecated
    public void translateAndRotate(class_4587 poseStack) {
        poseStack.method_46416(this.x / 16.0f + this.offsetX, this.y / 16.0f + this.offsetY, this.z / 16.0f + this.offsetZ);
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            poseStack.method_23760().method_23761().rotateZYX(this.zRot, this.yRot, this.xRot);
            poseStack.method_23760().method_23762().rotateZYX(this.zRot, this.yRot, this.xRot);
        }
    }

    public void translateAndRotateAndScale(class_4587 poseStack) {
        this.translateAndRotate(poseStack);
        poseStack.method_22907(this.additionalQuaternion);
        poseStack.method_22905(this.xScale, this.yScale, this.zScale);
    }

    private void compile(class_4587.class_4665 pose, class_4588 consumer, int lightmap, int overlay, float red, float green, float blue, float alpha) {
        Matrix3f normal = pose.method_23762();
        NORMALS[0].set(-normal.m10, -normal.m11, -normal.m12);
        NORMALS[1].set(normal.m10, normal.m11, normal.m12);
        NORMALS[2].set(-normal.m20, -normal.m21, -normal.m22);
        NORMALS[3].set(normal.m20, normal.m21, normal.m22);
        NORMALS[4].set(-normal.m00, -normal.m01, -normal.m02);
        NORMALS[5].set(normal.m00, normal.m01, normal.m02);
        for (BedrockCube bedrockCube : this.cubes) {
            bedrockCube.compile(pose, NORMALS, consumer, lightmap, overlay, red, green, blue, alpha);
        }
    }

    public BedrockCube getRandomCube(Random random) {
        return (BedrockCube)this.cubes.get(random.nextInt(this.cubes.size()));
    }

    public boolean isEmpty() {
        return this.cubes.isEmpty();
    }

    public void setInitRotationAngle(float x, float y, float z) {
        this.initRotX = x;
        this.initRotY = y;
        this.initRotZ = z;
    }

    public float getInitRotX() {
        return this.initRotX;
    }

    public float getInitRotY() {
        return this.initRotY;
    }

    public float getInitRotZ() {
        return this.initRotZ;
    }

    public void addChild(BedrockPart model) {
        this.children.add((Object)model);
        model.parent = this;
    }

    @Nullable
    public BedrockPart getParent() {
        return this.parent;
    }

    static {
        for (int i = 0; i < NORMALS.length; ++i) {
            BedrockPart.NORMALS[i] = new Vector3f();
        }
    }
}

