/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.simplebedrockmodel.client.manager;

import com.github.tartaricacid.simplebedrockmodel.SimpleBedrockModel;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.AbstractBedrockEntityModel;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class BedrockEntityModelSet<T extends AbstractBedrockEntityModel<? extends class_1297>>
extends class_4080<Void> {
    private Map<class_2960, T> models = ImmutableMap.of();
    private Map<class_2960, Function<InputStream, T>> knowLocations = Maps.newHashMap();

    void addModel(class_2960 location, Function<InputStream, T> function) {
        this.knowLocations.put(location, function);
    }

    void immutableKnowLocations() {
        this.knowLocations = ImmutableMap.copyOf(this.knowLocations);
    }

    protected Void prepare(class_3300 manager, class_3695 filler) {
        this.models = Maps.newHashMap();
        this.knowLocations.keySet().forEach(location -> {
            class_2960 path = new class_2960(location.method_12836(), "models/" + location.method_12832() + ".json");
            Function<InputStream, T> modelFunction = this.knowLocations.get(location);
            manager.method_14486(path).ifPresentOrElse(model -> {
                SimpleBedrockModel.LOGGER.info("Loading bedrock model file: {}", (Object)path);
                try (InputStream stream = model.method_14482();){
                    this.models.put((class_2960)location, (T)((AbstractBedrockEntityModel)modelFunction.apply(stream)));
                }
                catch (IOException e) {
                    SimpleBedrockModel.LOGGER.error("Failed to load model file: {}", (Object)path, (Object)e);
                }
            }, () -> SimpleBedrockModel.LOGGER.error("Not found model file: {}", (Object)path));
        });
        return null;
    }

    protected void apply(Void unused, class_3300 manager, class_3695 filler) {
        this.models = ImmutableMap.copyOf(this.models);
    }

    Map<class_2960, ? extends AbstractBedrockEntityModel<? extends class_1297>> getModels() {
        return this.models;
    }
}

