/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationState;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionArmor;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionManager;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalChair;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalHold;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalPassenger;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalSwing;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalUse;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalVehicle;
import com.github.tartaricacid.touhoulittlemaid.client.entity.GeckoMaidEntity;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidGameRecordManager;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.PlayState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.AnimationBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class AnimationManager {
    private static AnimationManager MANAGER;
    private final ReferenceArrayList<AnimationState>[] data = new ReferenceArrayList[5];

    public AnimationManager() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new ReferenceArrayList(6);
        }
    }

    public static AnimationManager getInstance() {
        if (MANAGER == null) {
            MANAGER = new AnimationManager();
        }
        return MANAGER;
    }

    @Nonnull
    public static PlayState playLoopAnimation(AnimationEvent<?> event, String animationName) {
        return AnimationManager.playAnimation(event, animationName, ILoopType.EDefaultLoopTypes.LOOP);
    }

    @Nonnull
    private static PlayState playAnimation(AnimationEvent<?> event, String animationName, ILoopType loopType) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName, loopType));
        return PlayState.CONTINUE;
    }

    @Nonnull
    private static PlayState playAnimation(AnimationEvent<?> event, String animationName) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName));
        return PlayState.CONTINUE;
    }

    public void register(AnimationState state) {
        this.data[state.getPriority()].add((Object)state);
    }

    public PlayState predicateParallel(AnimationEvent<?> event, String animationName) {
        if (class_310.method_1551().method_1493()) {
            return PlayState.STOP;
        }
        return AnimationManager.playLoopAnimation(event, animationName);
    }

    @NotNull
    public PlayState predicateMain(AnimationEvent<GeckoMaidEntity<?>> event) {
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        for (int i = 0; i <= 4; ++i) {
            PlayState vehicleAnimation;
            if (i == 1 && (vehicleAnimation = this.getVehicleAnimation(event)) != null) {
                return vehicleAnimation;
            }
            for (AnimationState state : this.data[i]) {
                if (!state.getPredicate().test(maid, event)) continue;
                String animationName = state.getAnimationName();
                ILoopType loopType = state.getLoopType();
                return AnimationManager.playAnimation(event, animationName, loopType);
            }
        }
        return PlayState.STOP;
    }

    public PlayState predicateOffhandHold(AnimationEvent<GeckoMaidEntity<?>> event) {
        class_1799 offhandItem;
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (!maid.asEntity().field_6252 && !maid.asEntity().method_6115() && (offhandItem = maid.asEntity().method_5998(class_1268.field_5810)).method_31574(class_1802.field_8399) && class_1764.method_7781((class_1799)offhandItem)) {
            return AnimationManager.playAnimation(event, "hold_offhand:charged_crossbow", ILoopType.EDefaultLoopTypes.LOOP);
        }
        if (this.checkSwingAndUse(maid, class_1268.field_5810)) {
            String name;
            class_2960 id;
            ConditionalHold conditionalHold;
            offhandItem = maid.asEntity().method_5998(class_1268.field_5810);
            if (!this.isSameItem(maid, offhandItem, class_1268.field_5810)) {
                maid.getHandItemsForAnimation()[class_1268.field_5810.ordinal()] = offhandItem;
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.LOOP);
            }
            if ((conditionalHold = ConditionManager.getHoldOffhand(id = event.getAnimatableEntity().getAnimationFileLocation())) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalHold.doTest(maid, class_1268.field_5810)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        return PlayState.STOP;
    }

    public PlayState predicateMainhandHold(AnimationEvent<GeckoMaidEntity<?>> event) {
        class_1799 mainHandItem;
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (!maid.asEntity().field_6252 && !maid.asEntity().method_6115()) {
            mainHandItem = maid.asEntity().method_5998(class_1268.field_5808);
            if (mainHandItem.method_31574(class_1802.field_8399) && class_1764.method_7781((class_1799)mainHandItem)) {
                return AnimationManager.playAnimation(event, "hold_mainhand:charged_crossbow", ILoopType.EDefaultLoopTypes.LOOP);
            }
            if (maid.hasFishingHook()) {
                return AnimationManager.playAnimation(event, "hold_mainhand:fishing", ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        if (this.checkSwingAndUse(maid, class_1268.field_5808)) {
            String name;
            class_2960 id;
            ConditionalHold conditionalHold;
            mainHandItem = maid.asEntity().method_5998(class_1268.field_5808);
            if (!this.isSameItem(maid, mainHandItem, class_1268.field_5808)) {
                maid.getHandItemsForAnimation()[class_1268.field_5808.ordinal()] = mainHandItem;
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.LOOP);
            }
            if ((conditionalHold = ConditionManager.getHoldMainhand(id = event.getAnimatableEntity().getAnimationFileLocation())) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalHold.doTest(maid, class_1268.field_5808)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        return PlayState.STOP;
    }

    private boolean isSameItem(IMaid maid, class_1799 maidItem, class_1268 hand) {
        class_1799 preItem = maid.getHandItemsForAnimation()[hand.ordinal()];
        if (preItem.method_7986()) {
            return class_1799.method_7984((class_1799)maidItem, (class_1799)preItem);
        }
        return class_1799.method_7973((class_1799)maidItem, (class_1799)preItem);
    }

    public PlayState predicateSwing(AnimationEvent<GeckoMaidEntity<?>> event) {
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid.asEntity().field_6252 && !maid.asEntity().method_6113()) {
            String name;
            ConditionalSwing conditionalSwing;
            if (maid.asEntity().field_6279 == 0) {
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.PLAY_ONCE);
            }
            class_2960 id = event.getAnimatableEntity().getAnimationFileLocation();
            ConditionalSwing conditionalSwing2 = conditionalSwing = maid.asEntity().field_6266 == class_1268.field_5808 ? ConditionManager.getSwingMainhand(id) : ConditionManager.getSwingOffhand(id);
            if (conditionalSwing != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalSwing.doTest(maid, maid.asEntity().field_6266)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.PLAY_ONCE);
            }
            String defaultSwing = maid.asEntity().field_6266 == class_1268.field_5808 ? "swing_hand" : "swing_offhand";
            return AnimationManager.playAnimation(event, defaultSwing, ILoopType.EDefaultLoopTypes.PLAY_ONCE);
        }
        return PlayState.CONTINUE;
    }

    public PlayState predicateUse(AnimationEvent<GeckoMaidEntity<?>> event) {
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid.asEntity().method_6115() && !maid.asEntity().method_6113()) {
            String name;
            if (maid.asEntity().method_6048() == 1) {
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.PLAY_ONCE);
            }
            if (maid.asEntity().method_6058() == class_1268.field_5808) {
                String name2;
                class_2960 id = event.getAnimatableEntity().getAnimationFileLocation();
                ConditionalUse conditionalUse = ConditionManager.getUseMainhand(id);
                if (conditionalUse != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name2 = conditionalUse.doTest(maid, class_1268.field_5808)})) {
                    return AnimationManager.playAnimation(event, name2, ILoopType.EDefaultLoopTypes.LOOP);
                }
                return AnimationManager.playAnimation(event, "use_mainhand", ILoopType.EDefaultLoopTypes.LOOP);
            }
            class_2960 id = event.getAnimatableEntity().getAnimationFileLocation();
            ConditionalUse conditionalUse = ConditionManager.getUseOffhand(id);
            if (conditionalUse != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalUse.doTest(maid, class_1268.field_5810)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
            return AnimationManager.playAnimation(event, "use_offhand", ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    public PlayState predicateMisc(AnimationEvent<GeckoMaidEntity<?>> event) {
        EntityMaid entityMaid;
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid instanceof EntityMaid && (entityMaid = (EntityMaid)maid).method_5854() instanceof EntitySit) {
            MaidGameRecordManager manager = entityMaid.getGameRecordManager();
            if (manager.isWin()) {
                return AnimationManager.playAnimation(event, "game_win", ILoopType.EDefaultLoopTypes.LOOP);
            }
            if (manager.isLost()) {
                return AnimationManager.playAnimation(event, "game_lost", ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        if (maid.isBegging()) {
            return AnimationManager.playAnimation(event, "beg", ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    public <T extends class_1308> PlayState predicateArmor(AnimationEvent<GeckoMaidEntity<T>> event, class_1304 slot) {
        IMaid maid = event.getAnimatableEntity().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        class_1799 itemBySlot = maid.asEntity().method_6118(slot);
        if (itemBySlot.method_7960()) {
            return PlayState.STOP;
        }
        class_2960 id = event.getAnimatableEntity().getAnimationFileLocation();
        ConditionArmor conditionArmor = ConditionManager.getArmor(id);
        if (conditionArmor != null) {
            String name = conditionArmor.doTest(maid, slot);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        class_2960 animation = event.getAnimatableEntity().getAnimationFileLocation();
        String defaultName = slot.method_5923() + ":default";
        if (GeckoLibCache.getInstance().getAnimations().get(animation).animations().containsKey(defaultName)) {
            return AnimationManager.playAnimation(event, defaultName, ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    @Nullable
    public PlayState getVehicleAnimation(AnimationEvent<GeckoMaidEntity<?>> event) {
        String name;
        ConditionalChair conditionalChair;
        class_1308 mob = event.getAnimatableEntity().getMaid().asEntity();
        if (mob == null) {
            return null;
        }
        class_1297 vehicle = mob.method_5854();
        if (vehicle == null || !vehicle.method_5805()) {
            return null;
        }
        class_2960 id = event.getAnimatableEntity().getAnimationFileLocation();
        if (vehicle instanceof EntityChair && (conditionalChair = ConditionManager.getChair(id)) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalChair.doTest(mob)})) {
            return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
        }
        ConditionalVehicle vehicleCondition = ConditionManager.getVehicle(id);
        if (vehicleCondition != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = vehicleCondition.doTest(mob)})) {
            return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
        }
        return null;
    }

    public PlayState predicatePassengerAnimation(AnimationEvent<GeckoMaidEntity<?>> event) {
        String name;
        class_1308 mob = event.getAnimatableEntity().getMaid().asEntity();
        if (mob == null) {
            return PlayState.STOP;
        }
        class_1297 passenger = mob.method_31483();
        if (passenger == null || !passenger.method_5805()) {
            return PlayState.STOP;
        }
        class_2960 id = event.getAnimatableEntity().getAnimationFileLocation();
        ConditionalPassenger conditionalPassenger = ConditionManager.getPassenger(id);
        if (conditionalPassenger != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalPassenger.doTest(mob)})) {
            return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    private boolean checkSwingAndUse(IMaid maid, class_1268 hand) {
        if (maid.asEntity().field_6252 && maid.asEntity().field_6266 == hand) {
            return false;
        }
        return !maid.asEntity().method_6115() || maid.asEntity().method_6058() != hand;
    }
}

