/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.api.client.gui.ITooltipButton;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTaskEnableEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.client.MaidContainerGuiEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.MaidSideTabs;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.MaidTabs;
import com.github.tartaricacid.touhoulittlemaid.client.gui.sound.MaidSoundPackGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidDownloadButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidSideTabButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidTabButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ScheduleButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TaskButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.compat.ipn.SortButtonScreen;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.event.OpenYsmMaidScreenEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidConfigMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidTaskMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.RequestEffectMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectMessage;
import com.github.tartaricacid.touhoulittlemaid.util.GuiTools;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_155;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_3544;
import net.minecraft.class_361;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMaidContainerGui<T extends AbstractMaidContainer>
extends class_465<T> {
    private static final class_2960 BG = new class_2960("touhou_little_maid", "textures/gui/maid_gui_main.png");
    private static final class_2960 SIDE = new class_2960("touhou_little_maid", "textures/gui/maid_gui_side.png");
    private static final class_2960 BUTTON = new class_2960("touhou_little_maid", "textures/gui/maid_gui_button.png");
    private static final class_2960 TASK = new class_2960("touhou_little_maid", "textures/gui/maid_gui_task.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private static final int TASK_COUNT_PER_PAGE = 12;
    private static int TASK_PAGE = 0;
    private static boolean TASK_LIST_OPEN = false;
    protected final EntityMaid maid;
    protected final IMaidTask task;
    private final Map<String, class_339> eventAddButtons = Maps.newHashMap();
    private class_361 home;
    private class_361 pick;
    private class_361 ride;
    private class_344 info;
    private class_344 skin;
    @Nullable
    private class_344 ysmSkin;
    private class_344 sound;
    private class_344 pageDown;
    private class_344 pageUp;
    private class_344 pageClose;
    private class_344 taskSwitch;
    private MaidDownloadButton modelDownload;
    private ScheduleButton<T> scheduleButton;
    private int counterTime = 0;

    public AbstractMaidContainerGui(T screenContainer, class_1661 inv, class_2561 titleIn) {
        super(screenContainer, inv, titleIn);
        this.field_2779 = 256;
        this.field_2792 = 256;
        this.maid = ((AbstractMaidContainer)this.field_2797).getMaid();
        this.task = ((AbstractMaidContainer)this.field_2797).getMaid().getTask();
    }

    protected void method_37067() {
        super.method_37067();
        this.eventAddButtons.clear();
    }

    protected void method_25426() {
        super.method_25426();
        if (this.maid == null) {
            return;
        }
        this.method_37067();
        this.initBaseData();
        this.initAdditionData();
        this.initBaseWidgets();
        this.initAdditionWidgets();
        MaidContainerGuiEvent.Init event = new MaidContainerGuiEvent.Init(this, this.field_2776, this.field_2800, this.eventAddButtons);
        ((MaidContainerGuiEvent.Init.Callback)MaidContainerGuiEvent.INIT.invoker()).onInit(event);
        this.eventAddButtons.values().forEach(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    protected void initBaseData() {
    }

    protected void initAdditionData() {
    }

    protected void initBaseWidgets() {
        this.addHomeButton();
        this.addPickButton();
        this.addRideButton();
        this.addDownloadButton();
        this.addStateButton();
        this.addTaskSwitchButton();
        this.addTaskControlButton();
        this.addTaskListButton();
        this.addScheduleButton();
        this.addTabsButton();
        this.addSideTabsButton();
    }

    protected void initAdditionWidgets() {
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.maid == null) {
            return;
        }
        this.drawModInfo(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.drawEffectInfo(graphics);
        this.drawCurrentTaskText(graphics);
        this.renderAddition(graphics, mouseX, mouseY, partialTicks);
        MaidContainerGuiEvent.Render renderEvent = new MaidContainerGuiEvent.Render(this, this.field_2776, this.field_2800, this.eventAddButtons, graphics, mouseX, mouseY, partialTicks);
        ((MaidContainerGuiEvent.Render.Callback)MaidContainerGuiEvent.RENDER.invoker()).onRender(renderEvent);
        this.method_2380(graphics, mouseX, mouseY);
        MaidContainerGuiEvent.Tooltip tooltipEvent = new MaidContainerGuiEvent.Tooltip(this, this.field_2776, this.field_2800, this.eventAddButtons, graphics, mouseX, mouseY, partialTicks);
        ((MaidContainerGuiEvent.Tooltip.Callback)MaidContainerGuiEvent.TOOLTIP.invoker()).onTooltip(tooltipEvent);
    }

    protected void renderAddition(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    private void drawModInfo(class_332 graphics) {
        String minecraftVersion = class_155.method_16673().method_48019();
        String modVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("touhou_little_maid").orElseThrow()).getMetadata().getVersion().getFriendlyString();
        String debugInfo = String.format("%s-%s", minecraftVersion, modVersion);
        graphics.method_25300(this.field_22793, debugInfo, this.field_2776 + 40, this.field_2800 - 4, class_124.field_1080.method_532().intValue());
    }

    private void drawEffectInfo(class_332 graphics) {
        if (TASK_LIST_OPEN) {
            return;
        }
        List<SendEffectMessage.EffectData> effects = this.maid.getEffects();
        if (!effects.isEmpty()) {
            int yOffset = 5;
            for (SendEffectMessage.EffectData effect : effects) {
                class_5250 text = class_2561.method_43471((String)effect.descriptionId);
                if (effect.amplifier >= 1 && effect.amplifier <= 9) {
                    class_5250 levelText = class_2561.method_43471((String)("enchantment.level." + (effect.amplifier + 1)));
                    text = text.method_10852(class_5244.field_41874).method_10852((class_2561)levelText);
                }
                String duration = effect.duration == -1 ? class_1074.method_4662((String)"effect.duration.infinite", (Object[])new Object[0]) : class_3544.method_15439((int)effect.duration);
                text = text.method_10852(class_5244.field_41874).method_27693(duration);
                graphics.method_27535(this.field_22793, (class_2561)text, this.field_2776 - this.field_22793.method_27525((class_5348)text) - 3, this.field_2800 + yOffset + 5, this.getPotionColor(effect.category));
                yOffset += 10;
            }
        }
    }

    private int getPotionColor(int category) {
        switch (category) {
            case 0: {
                return class_124.field_1060.method_532();
            }
            case 1: {
                return class_124.field_1061.method_532();
            }
        }
        return class_124.field_1078.method_532();
    }

    protected void method_2389(class_332 graphics, float partialTicks, int x, int y) {
        graphics.method_51448().method_46416(0.0f, 0.0f, -100.0f);
        this.method_25420(graphics);
        graphics.method_25302(BG, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        SortButtonScreen.renderBackground(graphics, this.field_2776 + 249, this.field_2800 + 166);
        this.drawMaidCharacter(graphics, x, y);
        this.drawBaseInfoGui(graphics);
        this.drawTaskListBg(graphics);
        this.drawSideTabGui(graphics, partialTicks, x, y);
    }

    protected void method_2380(class_332 graphics, int x, int y) {
        super.method_2380(graphics, x, y);
        this.renderTransTooltip(this.home, graphics, x, y, "gui.touhou_little_maid.button.home");
        this.renderTransTooltip(this.pick, graphics, x, y, "gui.touhou_little_maid.button.pickup");
        this.renderTransTooltip(this.ride, graphics, x, y, "gui.touhou_little_maid.button.maid_riding_set");
        this.renderTransTooltip(this.modelDownload, graphics, x, y, "gui.touhou_little_maid.button.model_download");
        this.renderTransTooltip(this.skin, graphics, x, y, "gui.touhou_little_maid.button.skin");
        if (this.ysmSkin != null) {
            this.renderTransTooltip(this.ysmSkin, graphics, x, y, "gui.touhou_little_maid.button.ysm_skin");
        }
        this.renderTransTooltip(this.sound, graphics, x, y, "gui.touhou_little_maid.button.sound");
        this.renderTransTooltip(this.pageUp, graphics, x, y, "gui.touhou_little_maid.task.previous_page");
        this.renderTransTooltip(this.pageDown, graphics, x, y, "gui.touhou_little_maid.task.next_page");
        this.renderTransTooltip(this.pageClose, graphics, x, y, "gui.touhou_little_maid.task.close");
        this.renderTransTooltip(this.taskSwitch, graphics, x, y, "gui.touhou_little_maid.task.switch");
        this.renderAdditionTransTooltip(graphics, x, y);
        this.renderMaidInfo(graphics, x, y);
        this.renderScheduleInfo(graphics, x, y);
        this.renderTaskButtonInfo(graphics, x, y);
        this.modelDownload.renderExtraTips(graphics);
    }

    protected void renderAdditionTransTooltip(class_332 graphics, int x, int y) {
    }

    protected void method_2388(class_332 graphics, int x, int y) {
        this.drawTaskPageCount(graphics);
    }

    private void addStateButton() {
        this.skin = new class_344(this.field_2776 + 62, this.field_2800 + 14, 9, 9, 72, 43, 10, BUTTON, b -> CacheIconManager.openMaidModelGui(this.maid));
        this.info = new class_344(this.field_2776 + 8, this.field_2800 + 14, 9, 9, 72, 65, 10, BUTTON, GuiTools.NO_ACTION);
        this.method_37063((class_364)this.skin);
        this.method_37063((class_364)this.info);
        if (YsmCompat.isInstalled()) {
            this.ysmSkin = new class_344(this.field_2776 + 52, this.field_2800 + 14, 9, 9, 144, 65, 10, BUTTON, b -> ((OpenYsmMaidScreenEvent.Callback)OpenYsmMaidScreenEvent.CALLBACK.invoker()).post(new OpenYsmMaidScreenEvent(this.maid)));
            this.sound = new class_344(this.field_2776 + 42, this.field_2800 + 14, 9, 9, 144, 43, 10, BUTTON, b -> Screens.getClient((class_437)this).method_1507((class_437)new MaidSoundPackGui(this.maid)));
            this.method_37063((class_364)this.ysmSkin);
            this.method_37063((class_364)this.sound);
        } else {
            this.sound = new class_344(this.field_2776 + 52, this.field_2800 + 14, 9, 9, 144, 43, 10, BUTTON, b -> Screens.getClient((class_437)this).method_1507((class_437)new MaidSoundPackGui(this.maid)));
            this.method_37063((class_364)this.sound);
        }
    }

    private void addTaskControlButton() {
        this.pageDown = new class_344(this.field_2776 - 72, this.field_2800 + 9, 16, 13, 93, 0, 14, TASK, b -> {
            List<IMaidTask> tasks = TaskManager.getTaskIndex();
            if (TASK_PAGE * 12 + 12 < tasks.size()) {
                ++TASK_PAGE;
                this.method_25426();
            }
        });
        this.pageUp = new class_344(this.field_2776 - 89, this.field_2800 + 9, 16, 13, 110, 0, 14, TASK, b -> {
            if (TASK_PAGE > 0) {
                --TASK_PAGE;
                this.method_25426();
            }
        });
        this.pageClose = new class_344(this.field_2776 - 19, this.field_2800 + 9, 13, 13, 127, 0, 14, TASK, b -> {
            TASK_LIST_OPEN = false;
            this.method_25426();
        });
        this.method_37063((class_364)this.pageUp);
        this.method_37063((class_364)this.pageDown);
        this.method_37063((class_364)this.pageClose);
        this.pageUp.field_22764 = TASK_LIST_OPEN;
        this.pageDown.field_22764 = TASK_LIST_OPEN;
        this.pageClose.field_22764 = TASK_LIST_OPEN;
    }

    private void addTaskListButton() {
        List<IMaidTask> tasks = TaskManager.getTaskIndex();
        if (TASK_PAGE * 12 >= tasks.size()) {
            TASK_PAGE = 0;
        }
        for (int count = 0; count < 12; ++count) {
            int index = TASK_PAGE * 12 + count;
            if (index >= tasks.size()) continue;
            this.drawPerTaskButton(tasks, count, index);
        }
    }

    private void drawPerTaskButton(List<IMaidTask> tasks, int count, int index) {
        IMaidTask maidTask = tasks.get(index);
        boolean[] enable = new boolean[]{true};
        ArrayList enableConditionDesc = Lists.newArrayList();
        if (maidTask != TaskManager.getIdleTask()) {
            MaidTaskEnableEvent event = new MaidTaskEnableEvent(maidTask, this.maid, enableConditionDesc);
            ((MaidTaskEnableEvent.Callback)MaidTaskEnableEvent.CALLBACK.invoker()).onMaidTaskEnable(event);
            if (event.isCanceled()) {
                enable[0] = false;
            } else if (!maidTask.isEnable(this.maid)) {
                enableConditionDesc.addAll(maidTask.getEnableConditionDesc(this.maid));
                enable[0] = false;
            }
        }
        TaskButton button = new TaskButton(maidTask, enable[0], this.field_2776 - 89, this.field_2800 + 23 + 19 * count, 83, 19, 93, 28, 20, TASK, 256, 256, b -> this.taskButtonPressed(maidTask, enable[0]), this.getTaskTooltips(maidTask, enable[0], enableConditionDesc), (class_2561)class_2561.method_43473());
        this.method_37063((class_364)button);
        button.field_22764 = TASK_LIST_OPEN;
    }

    protected void taskButtonPressed(IMaidTask maidTask, boolean enable) {
        if (enable && this.maid != null) {
            this.maid.setTask(maidTask);
            ClientPlayNetworking.send((class_2960)MaidTaskMessage.ID, (class_2540)MaidTaskMessage.encode(this.maid.method_5628(), maidTask.getUid()));
        }
    }

    private List<class_2561> getTaskTooltips(IMaidTask maidTask, boolean enable, List<Pair<String, Predicate<EntityMaid>>> enableConditionDesc) {
        List<Pair<String, Predicate<EntityMaid>>> conditions;
        List<class_2561> desc = ParseI18n.keysToTrans(maidTask.getDescription(this.maid), class_124.field_1080);
        if (!desc.isEmpty()) {
            desc.add(0, (class_2561)class_2561.method_43471((String)"task.touhou_little_maid.desc.title").method_27692(class_124.field_1065));
        }
        if (!enable) {
            desc.add((class_2561)class_2561.method_43470((String)" "));
            desc.add((class_2561)class_2561.method_43471((String)"task.touhou_little_maid.desc.enable_condition").method_27692(class_124.field_1065));
            for (Pair<String, Predicate<EntityMaid>> line : enableConditionDesc) {
                class_5250 prefix = class_2561.method_43470((String)"- ");
                String key = String.format("task.%s.%s.enable_condition.%s", maidTask.getUid().method_12836(), maidTask.getUid().method_12832(), line.getFirst());
                class_5250 condition = class_2561.method_43471((String)key);
                if (((Predicate)line.getSecond()).test(this.maid)) {
                    condition.method_27692(class_124.field_1060);
                } else {
                    condition.method_27692(class_124.field_1061);
                }
                desc.add((class_2561)prefix.method_10852((class_2561)condition));
            }
        }
        if (!(conditions = maidTask.getConditionDescription(this.maid)).isEmpty()) {
            desc.add((class_2561)class_2561.method_43470((String)" "));
            desc.add((class_2561)class_2561.method_43471((String)"task.touhou_little_maid.desc.condition").method_27692(class_124.field_1065));
        }
        for (Pair<String, Predicate<EntityMaid>> line : conditions) {
            class_5250 prefix = class_2561.method_43470((String)"- ");
            String key = String.format("task.%s.%s.condition.%s", maidTask.getUid().method_12836(), maidTask.getUid().method_12832(), line.getFirst());
            class_5250 condition = class_2561.method_43471((String)key);
            if (((Predicate)line.getSecond()).test(this.maid)) {
                condition.method_27692(class_124.field_1060);
            } else {
                condition.method_27692(class_124.field_1061);
            }
            desc.add((class_2561)prefix.method_10852((class_2561)condition));
        }
        if (Screens.getClient((class_437)this).field_1690.field_1827) {
            desc.add(class_5244.field_41874);
            desc.add((class_2561)class_2561.method_43469((String)"task.touhou_little_maid.advanced.id", (Object[])new Object[]{maidTask.getUid().method_12832()}).method_27692(class_124.field_1063));
        }
        return desc;
    }

    private void addScheduleButton() {
        this.scheduleButton = new ScheduleButton(this.field_2776 + 9, this.field_2800 + 187, this);
        this.method_37063((class_364)this.scheduleButton);
    }

    private void addTabsButton() {
        MaidTabButton[] tabs;
        MaidTabs maidTabs = new MaidTabs(this.maid.method_5628(), this.field_2776, this.field_2800);
        for (MaidTabButton button : tabs = maidTabs.getTabs(this)) {
            this.method_37063((class_364)button);
        }
    }

    private void addTaskSwitchButton() {
        this.taskSwitch = new class_344(this.field_2776 + 4, this.field_2800 + 159, 71, 21, 0, 42, 22, BUTTON, b -> {
            TASK_LIST_OPEN = !TASK_LIST_OPEN;
            this.method_25426();
        });
        this.method_37063((class_364)this.taskSwitch);
    }

    private void addRideButton() {
        this.ride = new class_361(this.field_2776 + 51, this.field_2800 + 206, 20, 20, this.maid.isRideable()){

            public void method_25348(double mouseX, double mouseY) {
                this.field_2194 = !this.field_2194;
                ClientPlayNetworking.send((class_2960)MaidConfigMessage.ID, (class_2540)MaidConfigMessage.encode(AbstractMaidContainerGui.this.maid.method_5628(), AbstractMaidContainerGui.this.maid.isHomeModeEnable(), AbstractMaidContainerGui.this.maid.isPickup(), this.field_2194, AbstractMaidContainerGui.this.maid.getSchedule()));
            }
        };
        this.ride.method_1962(84, 0, 21, 21, BUTTON);
        this.method_37063((class_364)this.ride);
    }

    private void addPickButton() {
        this.pick = new class_361(this.field_2776 + 30, this.field_2800 + 206, 20, 20, this.maid.isPickup()){

            public void method_25348(double mouseX, double mouseY) {
                this.field_2194 = !this.field_2194;
                ClientPlayNetworking.send((class_2960)MaidConfigMessage.ID, (class_2540)MaidConfigMessage.encode(AbstractMaidContainerGui.this.maid.method_5628(), AbstractMaidContainerGui.this.maid.isHomeModeEnable(), this.field_2194, AbstractMaidContainerGui.this.maid.isRideable(), AbstractMaidContainerGui.this.maid.getSchedule()));
            }
        };
        this.pick.method_1962(42, 0, 21, 21, BUTTON);
        this.method_37063((class_364)this.pick);
    }

    private void addHomeButton() {
        this.home = new class_361(this.field_2776 + 9, this.field_2800 + 206, 20, 20, this.maid.isHomeModeEnable()){

            public void method_25348(double mouseX, double mouseY) {
                this.field_2194 = !this.field_2194;
                ClientPlayNetworking.send((class_2960)MaidConfigMessage.ID, (class_2540)MaidConfigMessage.encode(AbstractMaidContainerGui.this.maid.method_5628(), this.field_2194, AbstractMaidContainerGui.this.maid.isPickup(), AbstractMaidContainerGui.this.maid.isRideable(), AbstractMaidContainerGui.this.maid.getSchedule()));
            }
        };
        this.home.method_1962(0, 0, 21, 21, BUTTON);
        this.method_37063((class_364)this.home);
    }

    private void addDownloadButton() {
        this.modelDownload = new MaidDownloadButton(this.field_2776 + 20, this.field_2800 + 230, BUTTON, this.maid);
        this.method_37063((class_364)this.modelDownload);
    }

    private void drawTaskPageCount(class_332 graphics) {
        if (TASK_LIST_OPEN) {
            String text = String.format("%d/%d", TASK_PAGE + 1, (TaskManager.getTaskIndex().size() - 1) / 12 + 1);
            graphics.method_51433(this.field_22793, text, -48, 12, 0x333333, false);
        }
    }

    private void drawCurrentTaskText(class_332 graphics) {
        IMaidTask task = this.maid.getTask();
        graphics.method_51427(task.getIcon(), this.field_2776 + 6, this.field_2800 + 161);
        List splitTexts = this.field_22793.method_1728((class_5348)task.getName(), 42);
        if (!splitTexts.isEmpty()) {
            graphics.method_51430(this.field_22793, (class_5481)splitTexts.get(0), this.field_2776 + 28, this.field_2800 + 165, 0x333333, false);
        }
    }

    private void renderMaidInfo(class_332 graphics, int mouseX, int mouseY) {
        if (this.info.method_49606()) {
            ArrayList list = Lists.newArrayList();
            String prefix = "\u00a7a\u2588 ";
            class_5250 title = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.info.title").method_27695(new class_124[]{class_124.field_1065, class_124.field_1073})).method_10852((class_2561)class_2561.method_43470((String)"\u00a7r "));
            if (this.maid.isStruckByLightning()) {
                title.method_10852((class_2561)class_2561.method_43470((String)"\u2740").method_27692(class_124.field_1079));
            }
            if (this.maid.method_5655()) {
                title.method_10852((class_2561)class_2561.method_43470((String)"\u271f").method_27692(class_124.field_1078));
            }
            list.add(title);
            if (this.maid.method_35057() != null) {
                list.add(class_2561.method_43470((String)prefix).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.info.owner").method_27693(": ").method_27692(class_124.field_1075)).method_10852(this.maid.method_35057().method_5476()));
            }
            CustomPackLoader.MAID_MODELS.getInfo(this.maid.getModelId()).ifPresent(info -> list.add(class_2561.method_43470((String)prefix).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.info.model_name").method_27693(": ").method_27692(class_124.field_1075)).method_10852((class_2561)ParseI18n.parse(info.getName()))));
            list.add(class_2561.method_43470((String)prefix).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.info.experience").method_27693(": ").method_27692(class_124.field_1075)).method_27693(String.valueOf(this.maid.getExperience())));
            list.add(class_2561.method_43470((String)prefix).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.info.favorability").method_27693(": ").method_27692(class_124.field_1075)).method_27693(String.valueOf(this.maid.getFavorability())));
            list.add(class_2561.method_43470((String)prefix).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43471((String)"block.touhou_little_maid.gomoku").method_27693(": ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43469((String)"tooltips.touhou_little_maid.info.game_skill.gomoku", (Object[])new Object[]{this.maid.getGameRecordManager().getGomokuWinCount(), MaidGomokuAI.getRank(this.maid)})));
            graphics.method_51434(this.field_22793, (List)list, mouseX, mouseY);
        }
    }

    private void renderScheduleInfo(class_332 graphics, int mouseX, int mouseY) {
        if (this.scheduleButton.method_49606()) {
            graphics.method_51434(this.field_22793, this.scheduleButton.getTooltips(), mouseX, mouseY);
        }
    }

    private void renderTaskButtonInfo(class_332 graphics, int x, int y) {
        ((ScreenAccessor)((Object)this)).tlm$getRenderables().stream().filter(b -> b instanceof ITooltipButton).forEach(b -> {
            ITooltipButton tooltipButton = (ITooltipButton)b;
            if (tooltipButton.isTooltipHovered()) {
                tooltipButton.renderTooltip(graphics, Screens.getClient((class_437)this), x, y);
            }
        });
    }

    private void drawMaidCharacter(class_332 graphics, int x, int y) {
        double scale = Screens.getClient((class_437)this).method_22683().method_4495();
        RenderSystem.enableScissor((int)((int)((double)(this.field_2776 + 6) * scale)), (int)((int)((double)(this.field_2800 + 107 + 42) * scale)), (int)((int)(67.0 * scale)), (int)((int)(95.0 * scale)));
        class_490.method_2486((class_332)graphics, (int)(this.field_2776 + 40), (int)(this.field_2800 + 100), (int)40, (float)(this.field_2776 + 40 - x), (float)(this.field_2800 + 70 - 20 - y), (class_1309)this.maid);
        RenderSystem.disableScissor();
    }

    private void drawTaskListBg(class_332 graphics) {
        if (TASK_LIST_OPEN) {
            graphics.method_25302(TASK, this.field_2776 - 93, this.field_2800 + 5, 0, 0, 92, 251);
        }
    }

    private void drawBaseInfoGui(class_332 graphics) {
        graphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
        graphics.method_25302(SIDE, this.field_2776 + 53, this.field_2800 + 113, 0, 0, 9, 9);
        graphics.method_25302(SIDE, this.field_2776 + 5, this.field_2800 + 113, 0, 9, 47, 9);
        double hp = this.maid.method_6032() / this.maid.method_6063();
        graphics.method_25302(SIDE, this.field_2776 + 7, this.field_2800 + 115, 2, 18, (int)(43.0 * hp), 5);
        this.drawNumberScale(graphics, this.maid.method_6032(), this.field_2776 + 63, this.field_2800 + 114);
        graphics.method_25302(SIDE, this.field_2776 + 53, this.field_2800 + 124, 9, 0, 9, 9);
        graphics.method_25302(SIDE, this.field_2776 + 5, this.field_2800 + 124, 0, 9, 47, 9);
        double armor = Math.min(this.maid.method_26825(class_5134.field_23724) / 20.0, 1.0);
        graphics.method_25302(SIDE, this.field_2776 + 7, this.field_2800 + 126, 2, 23, (int)(43.0 * armor), 5);
        this.drawNumberScale(graphics, this.maid.method_6096(), this.field_2776 + 63, this.field_2800 + 125);
        graphics.method_25302(SIDE, this.field_2776 + 53, this.field_2800 + 135, 18, 0, 9, 9);
        graphics.method_25302(SIDE, this.field_2776 + 5, this.field_2800 + 135, 0, 9, 47, 9);
        int exp = this.maid.getExperience();
        int count = exp / 120;
        double percent = (double)(exp % 120) / 120.0;
        graphics.method_25302(SIDE, this.field_2776 + 7, this.field_2800 + 137, 2, 28, (int)(43.0 * percent), 5);
        this.drawNumberScale(graphics, count, this.field_2776 + 63, this.field_2800 + 136);
        graphics.method_25302(SIDE, this.field_2776 + 53, this.field_2800 + 146, 27, 0, 9, 9);
        graphics.method_25302(SIDE, this.field_2776 + 5, this.field_2800 + 146, 0, 9, 47, 9);
        FavorabilityManager manager = this.maid.getFavorabilityManager();
        double percent2 = manager.getLevelPercent();
        graphics.method_25302(SIDE, this.field_2776 + 7, this.field_2800 + 148, 2, 33, (int)(43.0 * percent2), 5);
        this.drawNumberScale(graphics, manager.getLevel(), this.field_2776 + 63, this.field_2800 + 147);
        graphics.method_25302(SIDE, this.field_2776 + 94, this.field_2800 + 7, 107, 0, 149, 21);
        graphics.method_25302(SIDE, this.field_2776 + 6, this.field_2800 + 178, 0, 47, 67, 25);
    }

    private void drawNumberScale(class_332 graphics, double value, int posX, int posY) {
        String text = DECIMAL_FORMAT.format(value);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(0.5f, 0.5f, 1.0f);
        Objects.requireNonNull(this.field_22793);
        graphics.method_51433(this.field_22793, text, posX * 2, posY * 2 + 9 / 2, class_124.field_1063.method_532().intValue(), false);
        graphics.method_51448().method_22909();
    }

    protected void method_37432() {
        ++this.counterTime;
        if (this.counterTime % 20 == 0 && this.maid != null) {
            ClientPlayNetworking.send((class_2960)RequestEffectMessage.ID, (class_2540)RequestEffectMessage.encode(this.maid.method_5628()));
        }
    }

    public boolean isTaskListOpen() {
        return TASK_LIST_OPEN;
    }

    public List<class_768> getExclusionArea() {
        ArrayList<class_768> zones = new ArrayList<class_768>();
        zones.add(new class_768(this.field_2776 + 251, this.field_2800 + 28 + 9, 21, 99));
        if (this.isTaskListOpen()) {
            zones.add(new class_768(this.field_2776 - 93, this.field_2800 + 5, 92, 251));
        }
        return zones;
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    private void renderTransTooltip(class_344 button, class_332 graphics, int x, int y, String key) {
        if (button.method_49606()) {
            graphics.method_51434(this.field_22793, Collections.singletonList(class_2561.method_43471((String)key)), x, y);
        }
    }

    private void renderTransTooltip(class_361 button, class_332 graphics, int x, int y, String key) {
        if (button.method_49606()) {
            graphics.method_51434(this.field_22793, (List)Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43471((String)(key + "." + button.method_1965())), class_2561.method_43471((String)(key + ".desc"))}), x, y);
        }
    }

    private void addSideTabsButton() {
        MaidSideTabButton[] tabs;
        MaidSideTabs maidTabs = new MaidSideTabs(this.maid.method_5628(), this.field_2776 + 251, this.field_2800 + 28 + 9);
        for (MaidSideTabButton button : tabs = maidTabs.getTabs(this)) {
            this.method_37063((class_364)button);
        }
    }

    private void drawSideTabGui(class_332 graphics, float partialTicks, int x, int y) {
        graphics.method_25302(SIDE, this.field_2776 + 251 + 5, this.field_2800 + 28 + 9, 235, 107, 21, 50);
    }
}

