/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid;

import com.github.tartaricacid.touhoulittlemaid.api.event.client.OpenPatchouliBookEvent;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.mod.ClothConfigScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.mod.PatchouliWarningScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidSideTabButton;
import com.github.tartaricacid.touhoulittlemaid.compat.cloth.ClothConfigCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SideTab;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import java.util.List;
import java.util.Locale;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_4185;

public class MaidSideTabs<T extends AbstractMaidContainer> {
    private static final int SPACING = 25;
    private final int entityId;
    private final int rightPos;
    private final int topPos;

    public MaidSideTabs(int entityId, int rightPos, int topPos) {
        this.entityId = entityId;
        this.rightPos = rightPos;
        this.topPos = topPos;
    }

    public MaidSideTabButton[] getTabs(AbstractMaidContainerGui<T> screen) {
        MaidSideTabButton taskBook = this.genSideTabButton(SideTab.TASK_BOOK, b -> {
            if (FabricLoader.getInstance().isModLoaded("patchouli")) {
                EntityMaid maid = screen.getMaid();
                if (maid != null) {
                    ((OpenPatchouliBookEvent.Callback)OpenPatchouliBookEvent.CALLBACK.invoker()).post(new OpenPatchouliBookEvent(maid, maid.getTask()));
                }
            } else {
                PatchouliWarningScreen.open();
            }
        });
        MaidSideTabButton globalConfig = this.genSideTabButton(SideTab.GLOBAL_CONFIG, b -> {
            if (FabricLoader.getInstance().isModLoaded("cloth-config")) {
                ClothConfigCompat.openConfigScreen();
            } else {
                ClothConfigScreen.open();
            }
        });
        return new MaidSideTabButton[]{taskBook, globalConfig};
    }

    private MaidSideTabButton genSideTabButton(SideTab sideTab, class_4185.class_4241 onPressIn) {
        String name = sideTab.name().toLowerCase(Locale.ENGLISH);
        String titleLangKey = String.format("gui.touhou_little_maid.button.%s", name);
        String descLangKey = String.format("gui.touhou_little_maid.button.%s.desc", name);
        return new MaidSideTabButton(this.rightPos, this.topPos + sideTab.getIndex() * 25, sideTab.getIndex() * 25, onPressIn, List.of(class_2561.method_43471((String)titleLangKey), class_2561.method_43471((String)descLangKey)));
    }
}

