/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class MaidShootTargetAnyItemTask
extends class_4097<EntityMaid> {
    private final int attackCooldown;
    private final int chargeDurationTick;
    private final Predicate<class_1799> weaponTest;
    private int attackTime = -1;
    private int seeTime;
    private int swingTime;

    public MaidShootTargetAnyItemTask(int attackCooldown, int chargeDurationTick, Predicate<class_1799> weaponTest) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456), 1200);
        this.attackCooldown = attackCooldown;
        this.chargeDurationTick = chargeDurationTick;
        this.weaponTest = weaponTest;
    }

    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        Optional memory = owner.method_18868().method_18904(class_4140.field_22355);
        if (memory.isPresent()) {
            class_1309 target = (class_1309)memory.get();
            return owner.method_24520(this.weaponTest) && owner.canSee(target);
        }
        return false;
    }

    protected boolean canStillUse(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.method_18868().method_18896(class_4140.field_22355) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void tick(class_3218 worldIn, EntityMaid owner, long gameTime) {
        owner.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> {
            boolean itemCanNotUse;
            boolean seeTimeMoreThanZero;
            owner.method_5988().method_20248(target.method_23317(), target.method_23318(), target.method_23321());
            boolean canSee = owner.canSee((class_1309)target);
            boolean bl = seeTimeMoreThanZero = this.seeTime > 0;
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            boolean bl2 = itemCanNotUse = owner.method_6047().method_7935() <= 0;
            if (itemCanNotUse) {
                this.tickItemCanNotUse(owner, (class_1309)target, canSee);
            } else {
                this.tickItemCanUse(owner, (class_1309)target, canSee);
            }
        });
    }

    private void tickItemCanUse(EntityMaid owner, class_1309 target, boolean canSee) {
        if (owner.method_6115()) {
            int ticksUsingItem;
            if (!canSee && this.seeTime < -60) {
                owner.method_6021();
            } else if (canSee && (ticksUsingItem = owner.method_6048()) >= this.chargeDurationTick) {
                owner.method_6021();
                int powerTime = Math.max(ticksUsingItem, 20);
                owner.method_7105(target, class_1753.method_7722((int)powerTime));
                this.attackTime = this.attackCooldown;
            }
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            owner.method_6019(class_1268.field_5808);
        }
    }

    private void tickItemCanNotUse(EntityMaid owner, class_1309 target, boolean canSee) {
        if (owner.isSwingingArms()) {
            if (!canSee && this.seeTime < -60) {
                owner.setSwingingArms(false);
                this.swingTime = 0;
            } else if (canSee && this.swingTime >= this.chargeDurationTick) {
                int powerTime = Math.max(this.swingTime, 20);
                owner.method_7105(target, class_1753.method_7722((int)powerTime));
                this.attackTime = this.attackCooldown;
                owner.setSwingingArms(false);
                this.swingTime = 0;
            }
            ++this.swingTime;
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            owner.setSwingingArms(true);
        }
    }

    protected void stop(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.seeTime = 0;
        this.attackTime = -1;
        this.swingTime = 0;
        entityIn.method_6021();
    }
}

