/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackTridentTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidTridentTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1835;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_7893;

public class TaskTridentAttack
implements IRangedAttackTask {
    public static final class_2960 UID = new class_2960("touhou_little_maid", "trident_attack");

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_8547.method_7854();
    }

    @Override
    @Nullable
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, InitSounds.MAID_RANGE_ATTACK, 0.5f);
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(this::hasTrident, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.hasTrident(maid) || this.farAway((class_1309)target, maid));
        class_7893<EntityMaid> moveToTargetTask = MaidRangedWalkToTarget.create(0.6f);
        MaidAttackTridentTask maidAttackStrafingTask = new MaidAttackTridentTask();
        MaidTridentTargetTask shootTargetTask = new MaidTridentTargetTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(this::hasTrident, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.hasTrident(maid) || this.farAway((class_1309)target, maid));
        MaidTridentTargetTask shootTargetTask = new MaidTridentTargetTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public boolean canSee(EntityMaid maid, class_1309 target) {
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.TRIDENT_RANGE);
    }

    @Override
    public class_238 searchDimension(EntityMaid maid) {
        if (this.hasTrident(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.method_18410()) {
                return new class_238(maid.method_18412()).method_1014((double)searchRange);
            }
            return maid.method_5829().method_1014((double)searchRange);
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return ((Integer)MaidConfig.TRIDENT_RANGE.get()).intValue();
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, class_1309 target, float distanceFactor) {
        class_1799 tridentItem = shooter.method_6047().method_7972();
        Map enchantments = class_1890.method_8222((class_1799)tridentItem);
        if (!enchantments.isEmpty() && enchantments.containsKey(class_1893.field_9120)) {
            enchantments.remove(class_1893.field_9120);
            class_1890.method_8214((Map)enchantments, (class_1799)tridentItem);
        }
        class_1685 thrownTrident = new class_1685(shooter.field_6002, (class_1309)shooter, tridentItem);
        double x = target.method_23317() - shooter.method_23317();
        double y = target.method_23320() - shooter.method_23320();
        double z = target.method_23321() - shooter.method_23321();
        float distance = shooter.method_5739((class_1297)target);
        float velocity = class_3532.method_15363((float)(distance / 10.0f), (float)1.6f, (float)3.2f);
        float inaccuracy = 1.0f - class_3532.method_15363((float)(distance / 100.0f), (float)0.0f, (float)0.9f);
        thrownTrident.method_5875(true);
        thrownTrident.method_7485(x, y, z, velocity, inaccuracy);
        thrownTrident.field_7572 = class_1665.class_1666.field_7594;
        shooter.method_6047().method_7956(1, (class_1309)shooter, maid -> maid.method_20236(class_1268.field_5808));
        shooter.field_6002.method_8649((class_1297)thrownTrident);
        shooter.method_5783(class_3417.field_15001, 1.0f, 1.0f);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"has_trident", this::hasTrident)});
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        return stack.method_7909() instanceof class_1835;
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        return maid.method_5739((class_1297)target) > this.searchRadius(maid);
    }

    private boolean hasTrident(EntityMaid maid) {
        return maid.method_6047().method_7909() instanceof class_1835;
    }
}

