/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class SendEffectMessage {
    public static final class_2960 ID = TouhouLittleMaidFabric.getResourceLocation("send_effect");

    public static class_2540 encode(int id, List<EffectData> effects) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        buf.writeInt(effects.size());
        for (EffectData effect : effects) {
            effect.toBytes(buf);
        }
        return buf;
    }

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int id = buf.readInt();
        int size = buf.readInt();
        ArrayList effects = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            effects.add(EffectData.fromBytes(buf));
        }
        client.execute(() -> SendEffectMessage.handle(id, size, effects));
    }

    @Environment(value=EnvType.CLIENT)
    private static void handle(int id, int size, List<EffectData> effects) {
        EntityMaid maid;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_1297 entity = mc.field_1687.method_8469(id);
        if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).method_5805()) {
            maid.setEffects(effects);
        }
    }

    public static class EffectData {
        public String descriptionId;
        public int amplifier;
        public int duration;
        public int category;

        public EffectData(class_1293 effect) {
            this.descriptionId = effect.method_5586();
            this.amplifier = effect.method_5578();
            this.duration = effect.method_5584();
            this.category = effect.method_5579().method_18792().ordinal();
        }

        public EffectData(String descriptionId, int amplifier, int duration, int category) {
            this.descriptionId = descriptionId;
            this.amplifier = amplifier;
            this.duration = duration;
            this.category = category;
        }

        public static EffectData fromBytes(class_2540 buf) {
            return new EffectData(buf.method_19772(), buf.readInt(), buf.readInt(), buf.readInt());
        }

        public void toBytes(class_2540 buf) {
            buf.method_10814(this.descriptionId);
            buf.writeInt(this.amplifier);
            buf.writeInt(this.duration);
            buf.writeInt(this.category);
        }
    }
}

