/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_634;

public class SpawnParticleMessage {
    public static final class_2960 ID = TouhouLittleMaidFabric.getResourceLocation("spawn_particle");

    public static class_2540 encode(int entityId, Type particleType) {
        return SpawnParticleMessage.encode(entityId, particleType, 0);
    }

    public static class_2540 encode(int entityId, Type particleType, int delayTicks) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(entityId);
        buf.writeInt(particleType.ordinal());
        buf.method_10804(delayTicks);
        return buf;
    }

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.readInt();
        Type particleType = SpawnParticleMessage.getTypeByIndex(buf.readInt());
        int delayTicks = buf.method_10816();
        if (delayTicks <= 0) {
            client.execute(() -> SpawnParticleMessage.handleSpawnParticle(entityId, particleType));
        } else {
            client.execute(() -> CompletableFuture.runAsync(() -> SpawnParticleMessage.handleSpawnParticleDelay(entityId, particleType, delayTicks), class_156.method_18349()));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void handleSpawnParticleDelay(int entityId, Type particleType, int delayTicks) {
        try {
            Thread.sleep((long)delayTicks * 50L);
            class_310.method_1551().method_5382(() -> SpawnParticleMessage.handleSpawnParticle(entityId, particleType));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void handleSpawnParticle(int entityId, Type particleType) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_1297 e = mc.field_1687.method_8469(entityId);
        if (e instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)e;
            if (e.method_5805()) {
                switch (particleType.ordinal()) {
                    case 0: {
                        maid.spawnExplosionParticle();
                        return;
                    }
                    case 1: {
                        maid.spawnBubbleParticle();
                        return;
                    }
                    case 2: {
                        maid.spawnHeartParticle();
                        return;
                    }
                    case 3: {
                        maid.spawnRankUpParticle();
                        return;
                    }
                    case 4: {
                        maid.spawnRestoreHealthParticle(maid.method_6051().method_43048(3) + 7);
                        return;
                    }
                }
            }
        }
    }

    private static Type getTypeByIndex(int index) {
        return Type.values()[class_3532.method_15340((int)index, (int)0, (int)(Type.values().length - 1))];
    }

    public static enum Type {
        EXPLOSION,
        BUBBLE,
        HEART,
        RANK_UP,
        HEAL;

    }
}

