/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.setting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Site {
    private static final String CHAT = "chat";
    private static final String TTS = "tts";
    private static final String TYPE = "type";
    private static final String API_TYPE = "api_type";
    private static final String URL = "url";
    private static final String API_KEY = "api_key";
    private static final String MODELS = "models";
    private static final String EXTRA_ARGS = "extra_args";
    private String type;
    private String apiType;
    private String url;
    private String apiKey;
    private List<String> models;
    private Map<String, Object> extraArgs;

    public Site(String type, String apiType, String url, String apiKey, List<String> models, Map<String, Object> extraArgs) {
        this.type = type;
        this.apiType = apiType;
        this.url = url;
        this.apiKey = apiKey;
        this.models = models;
        this.extraArgs = extraArgs;
    }

    public Site(LinkedHashMap<String, Object> map) {
        this.type = Objects.requireNonNullElse((String)map.get(TYPE), "");
        this.apiType = Objects.requireNonNullElse((String)map.get(API_TYPE), "");
        this.url = Objects.requireNonNullElse((String)map.get(URL), "");
        this.apiKey = Objects.requireNonNullElse((String)map.get(API_KEY), "");
        this.models = Objects.requireNonNullElse((List)map.get(MODELS), Lists.newArrayList());
        this.extraArgs = Objects.requireNonNullElse((Map)map.get(EXTRA_ARGS), Maps.newHashMap());
    }

    public String getType() {
        return this.type;
    }

    public String getApiType() {
        return this.apiType;
    }

    public String getUrl() {
        return this.url;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public List<String> getModels() {
        return this.models;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setModels(List<String> models) {
        this.models = models;
    }

    public boolean isChat() {
        return CHAT.equals(this.type);
    }

    public boolean isTts() {
        return TTS.equals(this.type);
    }

    public Map<String, Object> getExtraArgs() {
        return this.extraArgs;
    }
}

