/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.game.chess;

import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Evaluate;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Util;

public class Search {
    private static final int HASH_ALPHA = 1;
    private static final int HASH_BETA = 2;
    private static final int HASH_PV = 3;
    private static final int LIMIT_DEPTH = 64;
    private static final int NULL_DEPTH = 2;
    private static final int RANDOM_MASK = 7;
    private static final int MAX_GEN_MOVES = 128;
    private static final int MATE_VALUE = 10000;
    private static final int WIN_VALUE = 9900;
    private int hashMask;
    private int mvResult;
    private int allNodes;
    private int allMillis;
    private HashItem[] hashTable;
    Position pos;
    int[] historyTable = new int[2048];
    int[][] mvKiller = new int[64][2];

    public Search(Position pos, int hashLevel) {
        this.pos = pos;
        this.hashMask = (1 << hashLevel) - 1;
        this.hashTable = new HashItem[this.hashMask + 1];
        for (int i = 0; i <= this.hashMask; ++i) {
            this.hashTable[i] = new HashItem(this);
        }
    }

    private HashItem getHashItem() {
        return this.hashTable[this.pos.zobristKey & this.hashMask];
    }

    private int probeHash(int vlAlpha, int vlBeta, int depth, int[] mv) {
        HashItem hash = this.getHashItem();
        if (hash.zobristLock != this.pos.zobristLock) {
            mv[0] = 0;
            return -10000;
        }
        mv[0] = hash.mv;
        boolean mate = false;
        if (hash.vl > 9900) {
            hash.vl = (short)(hash.vl - this.pos.distance);
            mate = true;
        } else if (hash.vl < -9900) {
            hash.vl = (short)(hash.vl + this.pos.distance);
            mate = true;
        }
        if (hash.depth >= depth || mate) {
            if (hash.flag == 2) {
                return hash.vl >= vlBeta ? (int)hash.vl : -10000;
            }
            if (hash.flag == 1) {
                return hash.vl <= vlAlpha ? (int)hash.vl : -10000;
            }
            return hash.vl;
        }
        return -10000;
    }

    private void recordHash(int flag, int vl, int depth, int mv) {
        HashItem hash = this.getHashItem();
        if (hash.depth > depth) {
            return;
        }
        hash.flag = (byte)flag;
        hash.depth = (byte)depth;
        hash.vl = vl > 9900 ? (short)(vl + this.pos.distance) : (vl < -9900 ? (short)(vl - this.pos.distance) : (short)vl);
        hash.mv = mv;
        hash.zobristLock = this.pos.zobristLock;
    }

    public void setBestMove(int mv, int depth) {
        int n = this.pos.historyIndex(mv);
        this.historyTable[n] = this.historyTable[n] + depth * depth;
        int[] killers = this.mvKiller[this.pos.distance];
        if (killers[0] != mv) {
            killers[1] = killers[0];
            killers[0] = mv;
        }
    }

    public int searchQuiesc(int vlAlpha_, int vlBeta) {
        int i;
        int genMoves;
        int vlAlpha = vlAlpha_;
        ++this.allNodes;
        int vl = this.pos.checkmateValue();
        if (vl >= vlBeta) {
            return vl;
        }
        if (this.pos.isRep()) {
            return this.pos.drawValue();
        }
        if (this.pos.distance == 64) {
            return Evaluate.evaluate(this.pos, vlAlpha, vlBeta);
        }
        int vlBest = -10000;
        int[] mvs = new int[128];
        int[] vls = new int[128];
        if (this.pos.inCheck()) {
            genMoves = this.pos.generateAllMoves(mvs);
            for (i = 0; i < genMoves; ++i) {
                vls[i] = this.historyTable[this.pos.historyIndex(mvs[i])];
            }
        } else {
            vl = Evaluate.evaluate(this.pos, vlAlpha, vlBeta);
            if (vl > vlBest) {
                if (vl >= vlBeta) {
                    return vl;
                }
                vlBest = vl;
                vlAlpha = Math.max(vl, vlAlpha);
            }
            genMoves = this.pos.generateMoves(mvs, vls);
        }
        Util.shellSort(mvs, vls, 0, genMoves);
        for (i = 0; i < genMoves; ++i) {
            if (!this.pos.makeMove(mvs[i])) continue;
            vl = -this.searchQuiesc(-vlBeta, -vlAlpha);
            this.pos.undoMakeMove();
            if (vl <= vlBest) continue;
            if (vl >= vlBeta) {
                return vl;
            }
            vlBest = vl;
            vlAlpha = Math.max(vl, vlAlpha);
        }
        return vlBest == -10000 ? this.pos.mateValue() : vlBest;
    }

    public int searchNoNull(int vlAlpha, int vlBeta, int depth) {
        return this.searchFull(vlAlpha, vlBeta, depth, true);
    }

    public int searchFull(int vlAlpha, int vlBeta, int depth) {
        return this.searchFull(vlAlpha, vlBeta, depth, false);
    }

    public int searchFull(int vlAlpha_, int vlBeta, int depth, boolean noNull) {
        int mv;
        int vlAlpha = vlAlpha_;
        if (depth <= 0) {
            return this.searchQuiesc(vlAlpha, vlBeta);
        }
        ++this.allNodes;
        int vl = this.pos.checkmateValue();
        if (vl >= vlBeta) {
            return vl;
        }
        if (this.pos.isRep()) {
            return this.pos.drawValue();
        }
        int[] mvHash = new int[1];
        vl = this.probeHash(vlAlpha, vlBeta, depth, mvHash);
        if (vl > -10000) {
            return vl;
        }
        if (this.pos.distance == 64) {
            return Evaluate.evaluate(this.pos, vlAlpha, vlBeta);
        }
        if (!noNull && !this.pos.inCheck() && this.pos.nullOkay()) {
            this.pos.nullMove();
            vl = -this.searchNoNull(-vlBeta, 1 - vlBeta, depth - 2 - 1);
            this.pos.undoNullMove();
            if (vl >= vlBeta && (this.pos.nullSafe() || this.searchNoNull(vlAlpha, vlBeta, depth - 2) >= vlBeta)) {
                return vl;
            }
        }
        int hashFlag = 1;
        int vlBest = -10000;
        int mvBest = 0;
        SortItem sort = new SortItem(mvHash[0]);
        while ((mv = sort.next()) > 0) {
            int newDepth;
            if (!this.pos.makeMove(mv)) continue;
            int n = newDepth = this.pos.inCheck() ? depth : depth - 1;
            if (vlBest == -10000) {
                vl = -this.searchFull(-vlBeta, -vlAlpha, newDepth);
            } else {
                vl = -this.searchFull(-vlAlpha - 1, -vlAlpha, newDepth);
                if (vl > vlAlpha && vl < vlBeta) {
                    vl = -this.searchFull(-vlBeta, -vlAlpha, newDepth);
                }
            }
            this.pos.undoMakeMove();
            if (vl <= vlBest) continue;
            vlBest = vl;
            if (vl >= vlBeta) {
                hashFlag = 2;
                mvBest = mv;
                break;
            }
            if (vl <= vlAlpha) continue;
            vlAlpha = vl;
            hashFlag = 3;
            mvBest = mv;
        }
        if (vlBest == -10000) {
            return this.pos.mateValue();
        }
        this.recordHash(hashFlag, vlBest, depth, mvBest);
        if (mvBest > 0) {
            this.setBestMove(mvBest, depth);
        }
        return vlBest;
    }

    public int searchRoot(int depth) {
        int mv;
        int vlBest = -10000;
        SortItem sort = new SortItem(this.mvResult);
        while ((mv = sort.next()) > 0) {
            int vl;
            int newDepth;
            if (!this.pos.makeMove(mv)) continue;
            int n = newDepth = this.pos.inCheck() ? depth : depth - 1;
            if (vlBest == -10000) {
                vl = -this.searchNoNull(-10000, 10000, newDepth);
            } else {
                vl = -this.searchFull(-vlBest - 1, -vlBest, newDepth);
                if (vl > vlBest) {
                    vl = -this.searchNoNull(-10000, -vlBest, newDepth);
                }
            }
            this.pos.undoMakeMove();
            if (vl <= vlBest) continue;
            vlBest = vl;
            this.mvResult = mv;
            if (vlBest <= -9900 || vlBest >= 9900) continue;
            vlBest += (Position.random.nextInt() & 7) - (Position.random.nextInt() & 7);
        }
        this.setBestMove(this.mvResult, depth);
        return vlBest;
    }

    public int searchMain(int millis) {
        return this.searchMain(64, millis);
    }

    public int searchMain(int depth, int millis) {
        int i;
        this.mvResult = this.pos.bookMove();
        if (this.mvResult > 0) {
            this.pos.makeMove(this.mvResult);
            if (!this.pos.isRep(2)) {
                this.pos.undoMakeMove();
                return this.mvResult;
            }
            this.pos.undoMakeMove();
        }
        int vl = 0;
        int[] mvs = new int[128];
        int genMoves = this.pos.generateAllMoves(mvs);
        for (i = 0; i < genMoves; ++i) {
            if (!this.pos.makeMove(mvs[i])) continue;
            this.pos.undoMakeMove();
            this.mvResult = mvs[i];
            ++vl;
        }
        if (vl == 1) {
            return this.mvResult;
        }
        for (i = 0; i <= this.hashMask; ++i) {
            HashItem hash = this.hashTable[i];
            hash.flag = 0;
            hash.depth = 0;
            hash.vl = 0;
            hash.zobristLock = 0;
            hash.mv = 0;
        }
        for (i = 0; i < 64; ++i) {
            this.mvKiller[i][1] = 0;
            this.mvKiller[i][0] = 0;
        }
        for (i = 0; i < 2048; ++i) {
            this.historyTable[i] = 0;
        }
        this.mvResult = 0;
        this.allNodes = 0;
        this.pos.distance = 0;
        Evaluate.preEval(this.pos);
        long t = System.currentTimeMillis();
        for (int i2 = 1; i2 <= depth && (vl = this.searchRoot(i2)) <= 9900 && vl >= -9900; ++i2) {
            this.allMillis = (int)(System.currentTimeMillis() - t);
            if (this.allMillis > millis) break;
        }
        return this.mvResult;
    }

    public int getKNPS() {
        return this.allNodes / this.allMillis;
    }

    class HashItem {
        byte depth;
        byte flag;
        short vl;
        int mv;
        int zobristLock;

        HashItem(Search this$0) {
        }
    }

    private class SortItem {
        private static final int PHASE_HASH = 0;
        private static final int PHASE_KILLER_1 = 1;
        private static final int PHASE_KILLER_2 = 2;
        private static final int PHASE_GEN_MOVES = 3;
        private static final int PHASE_REST = 4;
        private int index;
        private int moves;
        private int phase = 0;
        private int mvHash;
        private int mvKiller1;
        private int mvKiller2;
        private int[] mvs;
        private int[] vls;

        SortItem(int mvHash) {
            this.mvHash = mvHash;
            this.mvKiller1 = Search.this.mvKiller[Search.this.pos.distance][0];
            this.mvKiller2 = Search.this.mvKiller[Search.this.pos.distance][1];
        }

        int next() {
            if (this.phase == 0) {
                this.phase = 1;
                if (this.mvHash > 0 && Search.this.pos.legalMove(this.mvHash)) {
                    return this.mvHash;
                }
            }
            if (this.phase == 1) {
                this.phase = 2;
                if (this.mvKiller1 != this.mvHash && this.mvKiller1 > 0 && Search.this.pos.legalMove(this.mvKiller1)) {
                    return this.mvKiller1;
                }
            }
            if (this.phase == 2) {
                this.phase = 3;
                if (this.mvKiller2 != this.mvHash && this.mvKiller2 > 0 && Search.this.pos.legalMove(this.mvKiller2)) {
                    return this.mvKiller2;
                }
            }
            if (this.phase == 3) {
                this.phase = 4;
                this.mvs = new int[128];
                this.vls = new int[128];
                this.moves = Search.this.pos.generateAllMoves(this.mvs);
                for (int i = 0; i < this.moves; ++i) {
                    this.vls[i] = Search.this.historyTable[Search.this.pos.historyIndex(this.mvs[i])];
                }
                Util.shellSort(this.mvs, this.vls, 0, this.moves);
                this.index = 0;
            }
            while (this.index < this.moves) {
                int mv = this.mvs[this.index];
                ++this.index;
                if (mv == this.mvHash || mv == this.mvKiller1 || mv == this.mvKiller2) continue;
                return mv;
            }
            return 0;
        }
    }
}

