/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.init;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.PerspectiveBakedModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.ReplaceableBakedModel;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@Environment(value=EnvType.CLIENT)
public final class InitSpecialItemRender
implements ModelLoadingPlugin {
    private static final List<Pair<class_1091, class_1091>> PERSPECTIVE_MODEL_LIST = Lists.newArrayList();
    private static final List<Triple<class_1091, class_1091, Supplier<Boolean>>> REPLACEABLE_MODEL_LIST = Lists.newArrayList();
    private static final class_2960 LIFE_POINT = class_2960.method_60655((String)"touhou_little_maid", (String)"life_point");
    private static final class_2960 POINT_ITEM = class_2960.method_60655((String)"touhou_little_maid", (String)"point_item");
    private static final class_2960 SPAWN_BOX = class_2960.method_60655((String)"touhou_little_maid", (String)"item/spawn_box");
    private static final class_2960 REBORN_MAID = class_2960.method_60655((String)"touhou_little_maid", (String)"item/reborn_maid");
    private static final class_2960 SPAWN_LIGHTNING_BOLT = class_2960.method_60655((String)"touhou_little_maid", (String)"item/spawn_lightning_bolt");
    private static final String STANDALONE_VARIANT = "standalone";

    public void onInitializeModelLoader(ModelLoadingPlugin.Context plugin) {
        InitSpecialItemRender.register();
        InitSpecialItemRender.registerModels(plugin);
        plugin.modifyModelAfterBake().register((bakedModel, context) -> {
            class_1087 newModel;
            if (bakedModel == null) {
                return bakedModel;
            }
            class_1091 modelId = context.topLevelId();
            for (Pair<class_1091, class_1091> pair : PERSPECTIVE_MODEL_LIST) {
                if (modelId == null || !modelId.equals(pair.getLeft()) || (newModel = context.baker().method_45873(((class_1091)pair.getRight()).comp_2875(), context.settings())) == null) continue;
                return new PerspectiveBakedModel(bakedModel, newModel);
            }
            for (Triple triple : REPLACEABLE_MODEL_LIST) {
                if (modelId == null || !modelId.equals(triple.getLeft()) || (newModel = context.baker().method_45873(((class_1091)triple.getMiddle()).comp_2875(), context.settings())) == null) continue;
                return new ReplaceableBakedModel(bakedModel, newModel, (Supplier)triple.getRight());
            }
            return bakedModel;
        });
    }

    public static void register() {
        InitSpecialItemRender.addInHandModel(InitItems.HAKUREI_GOHEI);
        InitSpecialItemRender.addInHandModel(InitItems.SANAE_GOHEI);
        InitSpecialItemRender.addInHandModel(InitItems.EXTINGUISHER);
        InitSpecialItemRender.addInHandModel(InitItems.CAMERA);
        InitSpecialItemRender.addInHandModel(InitItems.MAID_BEACON);
        InitSpecialItemRender.addReplaceableModel(class_1802.field_8288, LIFE_POINT, () -> (Boolean)VanillaConfig.REPLACE_TOTEM_TEXTURE.get());
        InitSpecialItemRender.addReplaceableModel(class_1802.field_8287, POINT_ITEM, () -> (Boolean)VanillaConfig.REPLACE_XP_BOTTLE_TEXTURE.get());
    }

    public static void registerModels(ModelLoadingPlugin.Context plugin) {
        plugin.addModels(PERSPECTIVE_MODEL_LIST.stream().map(Pair::getRight).map(class_1091::comp_2875).toList());
        plugin.addModels(REPLACEABLE_MODEL_LIST.stream().map(Triple::getMiddle).map(class_1091::comp_2875).toList());
        plugin.addModels(new class_2960[]{SPAWN_BOX});
        plugin.addModels(new class_2960[]{REBORN_MAID});
        plugin.addModels(new class_2960[]{SPAWN_LIGHTNING_BOLT});
    }

    public static void addInHandModel(class_1792 item) {
        class_2960 res = class_7923.field_41178.method_10221((Object)item);
        if (res != class_7923.field_41178.method_10137()) {
            class_1091 rawName = class_1091.method_61078((class_2960)res);
            class_1091 inHandName = InitSpecialItemRender.standalone(class_2960.method_60655((String)res.method_12836(), (String)("item/" + res.method_12832() + "_in_hand")));
            PERSPECTIVE_MODEL_LIST.add((Pair<class_1091, class_1091>)Pair.of((Object)rawName, (Object)inHandName));
        }
    }

    public static void addReplaceableModel(class_1792 item, class_2960 replacedModel, Supplier<Boolean> isReplace) {
        class_2960 res = class_7923.field_41178.method_10221((Object)item);
        if (res != class_7923.field_41178.method_10137()) {
            class_1091 rawModelResourceLocation = class_1091.method_61078((class_2960)res);
            class_1091 replacedModelResourceLocation = InitSpecialItemRender.standalone(class_2960.method_60655((String)replacedModel.method_12836(), (String)("item/" + replacedModel.method_12832())));
            REPLACEABLE_MODEL_LIST.add((Triple<class_1091, class_1091, Supplier<Boolean>>)Triple.of((Object)rawModelResourceLocation, (Object)replacedModelResourceLocation, isReplace));
        }
    }

    private static class_1091 standalone(class_2960 id) {
        return new class_1091(id, STANDALONE_VARIANT);
    }
}

