/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz;

import cn.sh1rocu.touhoulittlemaid.api.event.ExplosionEvents;
import cn.sh1rocu.touhoulittlemaid.api.event.LivingAttackEvent;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidEquipEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidHurtEvent;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.entity.GeckoMaidEntity;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.TacInnerCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.client.GunBaseAnimation;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.client.GunGeckoAnimation;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.client.GunMaidRender;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.event.GunHurtMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.event.MaidGunEquipEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.PlayState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class TacCompat {
    public static final class_2960 MINIGUN_ID = class_2960.method_60655((String)"tacz", (String)"minigun");
    private static final String TACZ_ID = "tacz";
    private static boolean INSTALLED = false;

    public static boolean init() {
        if (FabricLoader.getInstance().isModLoaded(TACZ_ID)) {
            GunHurtMaidEvent gunHurtMaidEvent = new GunHurtMaidEvent();
            MaidHurtEvent.CALLBACK.register(gunHurtMaidEvent::onMaidHurt);
            EntityHurtByGunEvent.PRE.register(gunHurtMaidEvent::onGunHurt);
            LivingAttackEvent.CALLBACK.register(gunHurtMaidEvent::onPlayerHurt);
            ExplosionEvents.DETONATE.register(gunHurtMaidEvent::onExplosionDetonateEvent);
            MaidGunEquipEvent maidGunEquipEvent = new MaidGunEquipEvent();
            MaidEquipEvent.CALLBACK.register(maidGunEquipEvent::onMaidEquip);
            INSTALLED = true;
        }
        return INSTALLED;
    }

    public static boolean isInstalled() {
        return INSTALLED;
    }

    public static boolean isGun(class_1799 stack) {
        if (INSTALLED) {
            return TacInnerCompat.isGun(stack);
        }
        return false;
    }

    public static boolean isGrenade(class_1799 itemStack) {
        return false;
    }

    @Nullable
    public static class_2960 getGunId(class_1799 stack) {
        if (INSTALLED) {
            return TacInnerCompat.getGunId(stack);
        }
        return null;
    }

    public static boolean canSee(EntityMaid maid, class_1309 target) {
        if (INSTALLED) {
            return TacInnerCompat.canSee(maid, target);
        }
        return false;
    }

    public static int performGunAttack(EntityMaid shooter, class_1309 target, class_1799 gunItem) throws Exception {
        if (INSTALLED) {
            return TacInnerCompat.performGunAttack(shooter, target, gunItem);
        }
        return 100;
    }

    public static void stopAim(EntityMaid maid) {
        if (INSTALLED) {
            TacInnerCompat.stopAim(maid);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean onHoldGun(IMaid maid, @Nullable ModelRendererWrapper armLeft, @Nullable ModelRendererWrapper armRight) {
        if (INSTALLED) {
            return GunBaseAnimation.onHoldGun(maid, armLeft, armRight);
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static void addItemTranslate(class_4587 matrixStack, class_1799 itemStack, boolean isLeft) {
        if (INSTALLED) {
            GunMaidRender.addItemTranslate(matrixStack, itemStack, isLeft);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void renderBackGun(class_4587 matrixStack, class_4597 bufferIn, int packedLightIn, class_1799 stack, IMaid maid) {
        if (INSTALLED) {
            GunMaidRender.renderBackGun(matrixStack, bufferIn, packedLightIn, stack, maid);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void renderBackGun(class_1799 offhandItem, ILocationModel geoModel, IMaid maid, class_4587 poseStack, class_4597 bufferIn, int packedLight) {
        if (INSTALLED && TacCompat.isGun(offhandItem)) {
            poseStack.method_22903();
            GunMaidRender.renderBackGun(offhandItem, geoModel, maid, poseStack, bufferIn, packedLight);
            poseStack.method_22909();
        }
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public static PlayState playGunMainAnimation(IMaid maid, AnimationEvent<GeckoMaidEntity<?>> event, String animationName, ILoopType loopType) {
        if (INSTALLED && TacCompat.isGun(maid.asEntity().method_6047())) {
            return GunGeckoAnimation.playGunMainAnimation(event, animationName, loopType);
        }
        return null;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public static PlayState playGunHoldAnimation(class_1799 mainHandItem, AnimationEvent<GeckoMaidEntity<?>> event) {
        if (INSTALLED && TacCompat.isGun(mainHandItem)) {
            return GunGeckoAnimation.playGunHoldAnimation(event, mainHandItem);
        }
        return null;
    }
}

