/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz;

import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4215;

public class TacInnerCompat {
    @Nullable
    static class_2960 getGunId(class_1799 stack) {
        IGun iGun = IGun.getIGunOrNull((class_1799)stack);
        if (iGun != null) {
            return iGun.getGunId(stack);
        }
        return null;
    }

    static boolean isGun(class_1799 itemStack) {
        return itemStack.method_7909() instanceof IGun;
    }

    static boolean canSee(EntityMaid maid, class_1309 target) {
        class_1799 handItem = maid.method_6047();
        IGun iGun = IGun.getIGunOrNull((class_1799)handItem);
        if (iGun == null) {
            return class_4215.method_24565((class_1309)maid, (class_1309)target);
        }
        class_2960 gunId = iGun.getGunId(handItem);
        return TimelessAPI.getCommonGunIndex((class_2960)gunId).map(index -> {
            String type = index.getType();
            String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
            if (sniper.equals(type)) {
                return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
            }
            String shotgun = GunTabType.SHOTGUN.name().toLowerCase(Locale.ENGLISH);
            String pistol = GunTabType.PISTOL.name().toLowerCase(Locale.ENGLISH);
            String smg = GunTabType.SMG.name().toLowerCase(Locale.ENGLISH);
            if (shotgun.equals(type) || pistol.equals(type) || smg.equals(type)) {
                return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_NEAR_DISTANCE);
            }
            return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_MEDIUM_DISTANCE);
        }).orElse(class_4215.method_24565((class_1309)maid, (class_1309)target));
    }

    static int performGunAttack(EntityMaid shooter, class_1309 target, class_1799 gunItem) {
        IGun iGun = IGun.getIGunOrNull((class_1799)gunItem);
        if (iGun == null) {
            return 100;
        }
        class_2960 gunId = iGun.getGunId(gunItem);
        Optional optional = TimelessAPI.getCommonGunIndex((class_2960)gunId);
        if (optional.isEmpty()) {
            return 100;
        }
        CommonGunIndex gunIndex = (CommonGunIndex)optional.get();
        GunData gunData = gunIndex.getGunData();
        double x = target.method_23317() - shooter.method_23317();
        double y = target.method_23320() - shooter.method_23320();
        double z = target.method_23321() - shooter.method_23321();
        float yaw = (float)(-Math.toDegrees(Math.atan2(x, z)));
        float pitch = (float)(-Math.toDegrees(Math.atan2(y, Math.sqrt(x * x + z * z))));
        float radius = shooter.method_18413();
        IGunOperator gunOperator = IGunOperator.fromLivingEntity((class_1309)shooter);
        ShootResult result = gunOperator.shoot(() -> Float.valueOf(pitch), () -> Float.valueOf(yaw));
        if (result == ShootResult.ID_NOT_EXIST || result == ShootResult.NOT_GUN) {
            return 100;
        }
        String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
        if (gunIndex.getType().equals(sniper) && !gunOperator.getSynIsAiming()) {
            gunOperator.aim(true);
            return Math.round(gunData.getAimTime() * 20.0f) + 2;
        }
        if (!gunIndex.getType().equals(sniper)) {
            float distance = shooter.method_5739((class_1297)target);
            if (distance <= radius && gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
                return Math.round(gunData.getAimTime() * 20.0f) + 2;
            }
            if (distance > radius && !gunOperator.getSynIsAiming()) {
                gunOperator.aim(true);
                return Math.round(gunData.getAimTime() * 20.0f) + 2;
            }
        }
        if (result == ShootResult.NOT_DRAW) {
            gunOperator.draw(() -> ((EntityMaid)shooter).method_6047());
            return Math.round(gunData.getDrawTime() * 20.0f) + 2;
        }
        if (result == ShootResult.NEED_BOLT) {
            gunOperator.bolt();
            return Math.round(gunData.getBoltActionTime() * 20.0f) + 2;
        }
        if (result == ShootResult.NO_AMMO) {
            gunOperator.reload();
            float emptyTime = gunData.getReloadData().getCooldown().getEmptyTime();
            return Math.round(emptyTime * 20.0f) + 2;
        }
        FireMode fireMode = iGun.getFireMode(gunItem);
        if (fireMode == FireMode.SEMI || fireMode == FireMode.BURST) {
            return 10 + shooter.method_59922().method_43048(5);
        }
        return 2;
    }

    static void stopAim(EntityMaid maid) {
        class_1799 mainHandItem = maid.method_6047();
        IGun iGun = IGun.getIGunOrNull((class_1799)mainHandItem);
        if (iGun == null) {
            return;
        }
        class_2960 gunId = iGun.getGunId(mainHandItem);
        TimelessAPI.getCommonGunIndex((class_2960)gunId).ifPresent(gunIndex -> {
            IGunOperator gunOperator = IGunOperator.fromLivingEntity((class_1309)maid);
            if (gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
            }
        });
    }
}

