/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.api.mixin.INavigationMixin;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.MaidPathNavigation;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.MaidUnderWaterPathNavigation;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_10;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_5766;
import org.jetbrains.annotations.Nullable;

public class MaidNavigationManager {
    private final MaidPathNavigation basicNavigation;
    private final class_5766 waterNavigation;
    private final EntityMaid maid;
    private final class_1937 level;
    private Mode mode = Mode.GROUND;

    public MaidNavigationManager(EntityMaid maid) {
        this.maid = maid;
        this.level = maid.field_6002;
        this.basicNavigation = new MaidPathNavigation((class_1308)maid, maid.field_6002);
        this.waterNavigation = new MaidUnderWaterPathNavigation((class_1308)maid, maid.field_6002);
        maid.setNavigation((class_1408)this.basicNavigation);
    }

    public void tick() {
        if (!this.level.field_9236 && this.maid.method_6034()) {
            if (this.mode != Mode.WATER && this.maid.method_5799() && this.shouldStartOrStopSwim(5)) {
                if (this.switchToNavigation(Mode.WATER, (class_1408)this.waterNavigation)) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    this.maid.getSwimManager().setReadyToLand(false);
                }
            } else if (this.mode != Mode.WATER && this.maid.method_5869() && this.mayBeStuckUnderWater(this.maid.method_24515())) {
                if (this.switchToNavigation(Mode.WATER, (class_1408)this.waterNavigation)) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    this.maid.getSwimManager().setReadyToLand(false);
                }
            } else if (this.mode != Mode.WATER && this.maid.method_5799() && this.targetingUnderWater()) {
                if (this.switchToNavigation(Mode.WATER, (class_1408)this.waterNavigation)) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    this.maid.getSwimManager().setReadyToLand(false);
                }
            } else if (this.mode == Mode.WATER) {
                boolean shouldUseWater = this.maid.method_5799() && this.targetingUnderWater() || this.maid.method_5869() && this.mayBeStuckUnderWater(this.maid.method_24515());
                class_2338 endPos = this.getEndPos((class_1408)this.waterNavigation);
                if (!shouldUseWater && endPos != null) {
                    if (!this.shouldStartOrStopSwim(2)) {
                        if (!this.level.method_22351(endPos) && !this.level.method_22351(endPos.method_10074())) {
                            if (this.switchToNavigation(Mode.GROUND, (class_1408)this.basicNavigation)) {
                                this.maid.getSwimManager().setReadyToLand(true);
                                this.maid.getSwimManager().setWantToSwim(false);
                            }
                        } else if (this.isWaterSurface(endPos)) {
                            this.maid.getSwimManager().setWantToSwim(false);
                            this.maid.getSwimManager().setReadyToLand(false);
                        } else {
                            this.maid.getSwimManager().setWantToSwim(true);
                            this.maid.getSwimManager().setReadyToLand(false);
                        }
                    } else if (!this.maid.method_5799()) {
                        if (this.switchToNavigation(Mode.GROUND, (class_1408)this.basicNavigation)) {
                            this.maid.getSwimManager().setWantToSwim(false);
                            this.maid.getSwimManager().setReadyToLand(false);
                        }
                    } else if (!this.maid.method_5869()) {
                        this.maid.getSwimManager().setWantToSwim(false);
                    } else {
                        this.maid.getSwimManager().setWantToSwim(true);
                        this.maid.getSwimManager().setSwimTarget(endPos);
                    }
                } else if (endPos == null && this.maid.getSwimManager().isGoingToBreath()) {
                    this.maid.getSwimManager().setWantToSwim(false);
                } else if (shouldUseWater) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    if (endPos != null) {
                        this.maid.getSwimManager().setSwimTarget(endPos);
                    }
                }
            }
        }
        if (this.mode != Mode.WATER) {
            this.maid.getSwimManager().setWantToSwim(false);
        }
    }

    private boolean targetingUnderWater() {
        if (!this.maid.method_18868().method_18896(class_4140.field_18445)) {
            return false;
        }
        return this.isUnderWater(((class_4142)this.maid.method_18868().method_18904(class_4140.field_18445).get()).method_19094().method_18989());
    }

    private boolean switchToNavigation(Mode mode, class_1408 navigation) {
        class_1408 currentNavigation = this.maid.method_5942();
        if (!currentNavigation.method_6357()) {
            class_11 path = navigation.method_6348(currentNavigation.method_6345().method_45().method_22879(), 0);
            if (path != null && path.method_21655() && navigation.method_6334(path, ((INavigationMixin)currentNavigation).touhouLittleMaid$GetSpeedModifier())) {
                path.method_44();
                this.maid.setNavigation(navigation);
                this.mode = mode;
                currentNavigation.method_6340();
                return true;
            }
        } else {
            this.maid.setNavigation(navigation);
            navigation.method_6340();
            currentNavigation.method_6340();
            return true;
        }
        return false;
    }

    private boolean shouldStartOrStopSwim(int minimumDistance) {
        class_11 path = this.maid.method_5942().method_6345();
        if (path == null || path.method_46() || path.method_39() > path.method_38() - minimumDistance) {
            return false;
        }
        int i = path.method_39();
        int c = 0;
        while (c < minimumDistance) {
            if (!this.level.method_22351(path.method_40(i).method_22879())) {
                return false;
            }
            ++c;
            ++i;
        }
        return true;
    }

    private boolean mayBeStuckUnderWater(class_2338 pos) {
        return this.level.method_22351(pos) && !this.level.method_8320(pos.method_10084()).method_26171(class_10.field_50);
    }

    public class_1408 getBasicNavigation() {
        return this.basicNavigation;
    }

    public class_1408 getWaterNavigation() {
        return this.waterNavigation;
    }

    public boolean isWaterSurface(class_2338 pos) {
        return this.level.method_22351(pos) && this.level.method_8320(pos.method_10084()).method_26215() || this.level.method_22351(pos.method_10074()) && this.level.method_8320(pos).method_26215() || this.level.method_22351(pos.method_10084()) && this.level.method_8320(pos.method_10086(2)).method_26215();
    }

    private boolean isUnderWater(class_2338 blockPos) {
        return this.level.method_22351(blockPos) && this.level.method_22351(blockPos.method_10084()) && this.level.method_22351(blockPos.method_10086(2));
    }

    @Nullable
    public class_2338 getEndPos(class_1408 navigation) {
        if (navigation.method_6345() == null) {
            return null;
        }
        if (navigation.method_6345().method_45() == null) {
            return null;
        }
        return navigation.method_6345().method_45().method_22879();
    }

    public void resetNavigation() {
        this.maid.setNavigation((class_1408)this.basicNavigation);
        this.basicNavigation.method_6340();
        this.waterNavigation.method_6340();
        this.maid.getSwimManager().setWantToSwim(false);
        this.maid.getSwimManager().setReadyToLand(false);
        this.mode = Mode.GROUND;
    }

    public static enum Mode {
        GROUND,
        WATER;

    }
}

