/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.parser.ast;

import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.Expression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.ExpressionVisitor;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.Function;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class CallExpression
implements Expression {
    private final Function function;
    private final Function.ArgumentCollection arguments;

    public CallExpression(@NotNull Function function, @NotNull Function.ArgumentCollection arguments) {
        this.function = Objects.requireNonNull(function, "function");
        this.arguments = Objects.requireNonNull(arguments, "arguments");
    }

    @NotNull
    public Function function() {
        return this.function;
    }

    @NotNull
    public Function.ArgumentCollection arguments() {
        return this.arguments;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitCall(this);
    }

    public String toString() {
        return "Call(" + String.valueOf(this.function) + ", " + String.valueOf(this.arguments) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallExpression that = (CallExpression)o;
        if (!this.function.equals(that.function)) {
            return false;
        }
        return this.arguments.equals(that.arguments);
    }

    public int hashCode() {
        int result = this.function.hashCode();
        result = 31 * result + this.arguments.hashCode();
        return result;
    }
}

