/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.EntrypointException;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;

public final class AnnotatedInstanceUtil {
    public static List<ILittleMaid> getModExtensions() {
        return AnnotatedInstanceUtil.getInstances("little_maid_extension", ILittleMaid.class);
    }

    private static <T> List<T> getInstances(String entrypointContainerKey, Class<T> instanceClass) {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        List pluginContainers = fabricLoader.getEntrypointContainers(entrypointContainerKey, instanceClass);
        return pluginContainers.stream().mapMulti((entrypointContainer, consumer) -> {
            try {
                Object entrypoint = entrypointContainer.getEntrypoint();
                consumer.accept(entrypoint);
            }
            catch (EntrypointException e) {
                String modName;
                try {
                    ModContainer provider = entrypointContainer.getProvider();
                    ModMetadata metadata = provider.getMetadata();
                    modName = metadata.getName();
                }
                catch (RuntimeException ignored) {
                    modName = "unknown";
                }
                TouhouLittleMaid.LOGGER.error("{} specified an invalid entrypoint for its LittleMaid extension", (Object)modName, (Object)e);
            }
        }).collect(Collectors.toList());
    }
}

