/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlockEntityPersistentData;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class TileEntityModelSwitcher
extends class_2586
implements IBlockEntityPersistentData {
    public static final class_2591<TileEntityModelSwitcher> TYPE = class_2591.class_2592.method_20528(TileEntityModelSwitcher::new, (class_2248[])new class_2248[]{InitBlocks.MODEL_SWITCHER}).method_11034(null);
    public static final String INFO_LIST = "info_list";
    public static final String ENTITY_UUID = "entity_uuid";
    public static final String LIST_INDEX = "list_index";
    private List<ModeInfo> infoList = Lists.newArrayList();
    private boolean isPowered;
    private UUID uuid;
    private int index;

    public TileEntityModelSwitcher(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(TYPE, pWorldPosition, pBlockState);
    }

    protected void method_11007(class_2487 pTag, class_7225.class_7874 pRegistries) {
        class_2499 listTag = new class_2499();
        for (ModeInfo info : this.infoList) {
            listTag.add((Object)info.serialize());
        }
        this.getPersistentData().method_10566(INFO_LIST, (class_2520)listTag);
        if (this.uuid != null) {
            this.getPersistentData().method_10566(ENTITY_UUID, (class_2520)class_2512.method_25929((UUID)this.uuid));
        }
        this.getPersistentData().method_10569(LIST_INDEX, this.index);
        super.method_11007(pTag, pRegistries);
    }

    public void method_11014(class_2487 pTag, class_7225.class_7874 pRegistries) {
        super.method_11014(pTag, pRegistries);
        this.infoList.clear();
        class_2499 listTag = this.getPersistentData().method_10554(INFO_LIST, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            ModeInfo info = new ModeInfo();
            info.deserialize(listTag.method_10602(i));
            this.infoList.add(info);
        }
        class_2520 uuidTag = this.getPersistentData().method_10580(ENTITY_UUID);
        if (uuidTag != null) {
            this.uuid = class_2512.method_25930((class_2520)uuidTag);
        }
        this.index = this.getPersistentData().method_10550(LIST_INDEX);
    }

    public class_2487 method_16887(class_7225.class_7874 pRegistries) {
        return this.method_38244(pRegistries);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        this.refresh();
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean powered) {
        this.isPowered = powered;
    }

    @Nullable
    public ModeInfo getModelInfo() {
        if (0 <= this.index && this.index < this.infoList.size()) {
            return this.infoList.get(this.index);
        }
        return null;
    }

    public List<ModeInfo> getInfoList() {
        return this.infoList;
    }

    public void setInfoList(List<ModeInfo> infoList) {
        this.infoList = infoList;
        this.refresh();
    }

    public void refresh() {
        this.method_5431();
        if (this.field_11863 != null) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8413(this.field_11867, state, state, 3);
        }
    }

    public static class ModeInfo {
        public static final class_9139<ByteBuf, ModeInfo> MODE_INFO_STREAM_CODEC = class_9139.method_56436((class_9139)class_2960.field_48267, ModeInfo::getModelId, (class_9139)class_9135.field_48554, ModeInfo::getText, (class_9139)class_2350.field_48450, ModeInfo::getDirection, ModeInfo::new);
        private class_2960 modelId;
        private String text;
        private class_2350 direction;

        public ModeInfo() {
        }

        public ModeInfo(class_2960 modelId, String text, class_2350 direction) {
            this.modelId = modelId;
            this.text = text;
            this.direction = direction;
        }

        public static ModeInfo fromBuf(class_2540 buf) {
            return new ModeInfo(buf.method_10810(), buf.method_19772(), class_2350.method_10139((int)buf.method_10816()));
        }

        public class_2960 getModelId() {
            return this.modelId;
        }

        public void setModelId(class_2960 modelId) {
            this.modelId = modelId;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public class_2350 getDirection() {
            return this.direction;
        }

        public void setDirection(class_2350 direction) {
            this.direction = direction;
        }

        public void toBuf(class_2540 buf) {
            buf.method_10812(this.modelId);
            buf.method_10814(this.text);
            buf.method_10804(this.direction.method_10161());
        }

        public class_2487 serialize() {
            class_2487 tag = new class_2487();
            tag.method_10582("model_id", this.modelId.toString());
            tag.method_10582("text", this.text);
            tag.method_10569("direction", this.direction.method_10161());
            return tag;
        }

        public void deserialize(class_2487 nbt) {
            this.modelId = class_2960.method_60654((String)nbt.method_10558("model_id"));
            this.text = nbt.method_10558("text");
            this.direction = class_2350.method_10139((int)nbt.method_10550("direction"));
        }
    }
}

