package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetBeaconPotionMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import java.util.function.Consumer;

public class BeaconEffectButton extends TouhouStateSwitchButton {
    private static final class_2960 BG = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/maid_beacon.png");
    private final class_1058 sprite;
    private final class_2561 tooltips;
    private final int potionIndex;
    private final class_2338 pos;
    private final Consumer<Boolean> onClick;

    public BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect effect, int xIn, int yIn, int potionIndex, TileEntityMaidBeacon beacon, Consumer<Boolean> onClick) {
        super(xIn, yIn, 22, 22, potionIndex == effect.ordinal());
        this.initTextureValues(0, 111, 22, 22, BG);
        this.sprite = class_310.method_1551().method_18505().method_18663(effect.getEffect());
        this.tooltips = effect.getEffect().method_5560();
        this.potionIndex = effect.ordinal();
        this.pos = beacon.method_11016();
        this.onClick = onClick;
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        this.isStateTriggered = !this.isStateTriggered;
        ClientPlayNetworking.send(SetBeaconPotionMessage.ID, SetBeaconPotionMessage.encode(pos, isStateTriggered ? potionIndex : -1));
        this.onClick.accept(this.isStateTriggered);
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25298(this.method_46426() + 2, this.method_46427() + 2, 0, 18, 18, this.sprite);
    }

    public void renderToolTip(class_332 graphics, class_437 screen, int pMouseX, int pMouseY) {
        if (this.field_22762) {
            graphics.method_51438(Screens.getClient(screen).field_1772, tooltips, pMouseX, pMouseY);
        }
    }
}