package com.github.tartaricacid.touhoulittlemaid.client.init;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.PerspectiveBakedModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.ReplaceableBakedModel;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.google.common.collect.Lists;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

import java.util.List;
import java.util.function.Supplier;

@Environment(EnvType.CLIENT)
public final class InitSpecialItemRender implements ModelLoadingPlugin {
    private static final List<Pair<class_1091, class_2960>> PERSPECTIVE_MODEL_LIST = Lists.newArrayList();
    private static final List<Triple<class_1091, class_2960, Supplier<Boolean>>> REPLACEABLE_MODEL_LIST = Lists.newArrayList();

    private static final class_2960 LIFE_POINT = new class_2960(TouhouLittleMaid.MOD_ID, "life_point");
    private static final class_2960 POINT_ITEM = new class_2960(TouhouLittleMaid.MOD_ID, "point_item");

    @Override
    public void onInitializeModelLoader(Context plugin) {
        register();
        registerModels(plugin);
        plugin.modifyModelAfterBake().register((bakedModel, context) -> {
            if (bakedModel == null)
                return bakedModel;
            class_2960 id = context.id();
            for (Pair<class_1091, class_2960> pair : PERSPECTIVE_MODEL_LIST) {
                if (id instanceof class_1091 modelId && modelId.equals(pair.getLeft())) {
                    class_1087 newModel = context.baker().method_45873(pair.getRight(), context.settings());
                    if (newModel != null)
                        return new PerspectiveBakedModel(bakedModel, newModel);
                }
            }

            for (Triple<class_1091, class_2960, Supplier<Boolean>> triple : REPLACEABLE_MODEL_LIST) {
                if (id instanceof class_1091 modelId && modelId.equals(triple.getLeft())) {
                    class_1087 newModel = context.baker().method_45873(triple.getMiddle(), context.settings());
                    if (newModel != null)
                        return new ReplaceableBakedModel(bakedModel, newModel, triple.getRight());
                }
            }
            return bakedModel;
        });
    }

    public static void register() {
        addInHandModel(InitItems.HAKUREI_GOHEI);
        addInHandModel(InitItems.SANAE_GOHEI);
        addInHandModel(InitItems.EXTINGUISHER);
        addInHandModel(InitItems.CAMERA);
        addInHandModel(InitItems.MAID_BEACON);

        addReplaceableModel(class_1802.field_8288, LIFE_POINT, () -> VanillaConfig.REPLACE_TOTEM_TEXTURE.get());
        addReplaceableModel(class_1802.field_8287, POINT_ITEM, () -> VanillaConfig.REPLACE_XP_BOTTLE_TEXTURE.get());
    }

    public static void registerModels(Context plugin) {
        //PERSPECTIVE_MODEL_LIST.forEach((pair) ->   event.register(pair.getRight()));
        //REPLACEABLE_MODEL_LIST.forEach((triple) -> event.register(triple.getMiddle()));
        plugin.addModels(PERSPECTIVE_MODEL_LIST.stream().map(Pair::getRight).toList());
        plugin.addModels(REPLACEABLE_MODEL_LIST.stream().map(Triple::getMiddle).toList());
    }

    public static void addInHandModel(class_1792 item) {
        class_2960 res = class_7923.field_41178.method_10221(item);
        if (res != null) {
            class_1091 rawName = new class_1091(res, "inventory");
            class_2960 inHandName = new class_2960(res.method_12836(), "item/" + res.method_12832() + "_in_hand");
            PERSPECTIVE_MODEL_LIST.add(Pair.of(rawName, inHandName));
        }
    }

    public static void addReplaceableModel(class_1792 item, class_2960 replacedModel, Supplier<Boolean> isReplace) {
        class_2960 res = class_7923.field_41178.method_10221(item);
        if (res != null) {
            class_1091 rawModelResourceLocation = new class_1091(res, "inventory");
            class_2960 replacedModelResourceLocation = new class_2960(replacedModel.method_12836(), "item/" + replacedModel.method_12832());
            REPLACEABLE_MODEL_LIST.add(Triple.of(rawModelResourceLocation, replacedModelResourceLocation, isReplace));
        }
    }
}
