package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import net.minecraft.class_1303;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import net.minecraft.class_902;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ReplaceExperienceOrbRenderer extends class_897<class_1303> {
    private static final class_2960 POINT_ITEM_TEXTURE = new class_2960(TouhouLittleMaid.MOD_ID, "textures/entity/point_item.png");
    private static final class_1921 RENDER_TYPE = class_1921.method_23578(POINT_ITEM_TEXTURE);
    private final class_902 vanillaRender;

    public ReplaceExperienceOrbRenderer(class_5617.class_5618 context) {
        super(context);
        this.field_4673 = 0.15F;
        this.field_4672 = 0.75F;
        this.vanillaRender = new class_902(context);
    }

    private static void vertex(class_4588 pConsumer, Matrix4f pMatrix, Matrix3f pMatrixNormal, float pX, float pY, int pRed, int pGreen, int pBlue, float pTexU, float pTexV, int pPackedLight) {
        pConsumer.method_22918(pMatrix, pX, pY, 0.0F).method_1336(pRed, pGreen, pBlue, 128).method_22913(pTexU, pTexV).method_22922(class_4608.field_21444).method_22916(pPackedLight).method_23763(pMatrixNormal, 0.0F, 1.0F, 0.0F).method_1344();
    }

    protected int getBlockLightLevel(class_1303 pEntity, class_2338 pPos) {
        return class_3532.method_15340(super.method_24087(pEntity, pPos) + 7, 0, 15);
    }

    @Override
    public void render(class_1303 orb, float pEntityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        if (VanillaConfig.REPLACE_XP_TEXTURE.get()) {
            renderPointItem(orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            vanillaRender.method_3966(orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    private void renderPointItem(class_1303 orb, float pEntityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        poseStack.method_22903();
        int icon = orb.method_5920();
        float texU1 = (float) (icon % 4 * 16) / 64.0F;
        float texU2 = (float) (icon % 4 * 16 + 16) / 64.0F;
        float texV2 = (float) (icon / 4 * 16) / 64.0F;
        float texV1 = (float) (icon / 4 * 16 + 16) / 64.0F;
        poseStack.method_46416(0.0F, 0.1F, 0.0F);
        poseStack.method_22907(this.field_4676.method_24197());
        poseStack.method_22905(0.3F, 0.3F, 0.3F);
        class_4588 consumer = buffer.getBuffer(RENDER_TYPE);
        class_4587.class_4665 lasted = poseStack.method_23760();
        Matrix4f pose = lasted.method_23761();
        Matrix3f normal = lasted.method_23762();
        vertex(consumer, pose, normal, -0.5F, -0.25F, 255, 255, 255, texU1, texV1, packedLight);
        vertex(consumer, pose, normal, 0.5F, -0.25F, 255, 255, 255, texU2, texV1, packedLight);
        vertex(consumer, pose, normal, 0.5F, 0.75F, 255, 255, 255, texU2, texV2, packedLight);
        vertex(consumer, pose, normal, -0.5F, 0.75F, 255, 255, 255, texU1, texV2, packedLight);
        poseStack.method_22909();
        super.method_3936(orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public class_2960 getTextureLocation(class_1303 pEntity) {
        return POINT_ITEM_TEXTURE;
    }
}
