package com.github.tartaricacid.touhoulittlemaid.compat.jade.provider;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.google.common.collect.Lists;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.*;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public enum TombstoneProvider implements IServerExtensionProvider<Object, class_1799>, IClientExtensionProvider<class_1799, ItemView> {

    INSTANCE;

    private static final class_2960 UID = new class_2960(TouhouLittleMaid.MOD_ID, "tombstone");

    @Override
    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<class_1799>> list) {
        return ClientViewGroup.map(list, ItemView::new, null);
    }

    @Override
    public @Nullable List<ViewGroup<class_1799>> getGroups(class_3222 player, class_3218 world, Object target, boolean showDetails) {
        if (target instanceof EntityTombstone tombstone) {
            List<class_1799> list = Lists.newArrayList();
            ItemStackHandler items = tombstone.getItems();
            for (int i = 0; i < items.getSlots(); i++) {
                class_1799 stack = items.getStackInSlot(i);
                list.add(stack.method_7972());
            }
            return List.of(new ViewGroup<>(list));
        }
        return null;
    }

    @Override
    public class_2960 getUid() {
        return UID;
    }
}