package com.github.tartaricacid.touhoulittlemaid.compat.jei.altar;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import java.util.Collections;
import java.util.List;

public class AltarRecipeCategory implements IRecipeCategory<AltarRecipeWrapper> {
    public static final RecipeType<AltarRecipeWrapper> ALTAR = RecipeType.create(TouhouLittleMaid.MOD_ID, "altar", AltarRecipeWrapper.class);
    private static final class_2960 ALTAR_ICON = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/altar_icon.png");
    private static final class_2960 POWER_ICON = new class_2960(TouhouLittleMaid.MOD_ID, "textures/entity/power_point.png");
    private static final class_5250 TITLE = class_2561.method_43471("jei.touhou_little_maid.altar_craft.title");
    private final IDrawableStatic bgDraw;
    private final IDrawable slotDraw;
    private final IDrawableStatic altarDraw;
    private final IDrawableStatic powerDraw;

    public AltarRecipeCategory(IGuiHelper guiHelper) {
        this.bgDraw = guiHelper.createBlankDrawable(160, 125);
        this.slotDraw = guiHelper.getSlotDrawable();
        this.altarDraw = guiHelper.drawableBuilder(ALTAR_ICON, 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.powerDraw = guiHelper.drawableBuilder(POWER_ICON, 32, 0, 16, 16).setTextureSize(64, 64).build();
    }

    @Override
    public void draw(AltarRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        int darkGray = 0x555555;
        class_327 font = class_310.method_1551().field_1772;
        String result = class_1074.method_4662("jei.touhou_little_maid.altar_craft.result", class_1074.method_4662(recipe.getLangKey()));

        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(0.8f, 0.8f, 0.8f);
        powerDraw.draw(graphics, 90, 50);
        graphics.method_51448().method_22909();

        graphics.method_51433(font, String.format("×%.2f", recipe.getPowerCost()), 65, 55, darkGray, false);
        graphics.method_51433(font, result, (int) ((bgDraw.getWidth() - font.method_1727(result)) / 2.0f), 85, darkGray, false);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, AltarRecipeWrapper recipe, IFocusGroup focuses) {
        List<List<class_1799>> inputs = recipe.getInputs();
        class_1799 output = recipe.getOutput();
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 35).addItemStacks(getInput(inputs, 0)).setBackground(slotDraw, -1, -1);
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 55).addItemStacks(getInput(inputs, 1)).setBackground(slotDraw, -1, -1);
        builder.addSlot(RecipeIngredientRole.INPUT, 60, 15).addItemStacks(getInput(inputs, 2)).setBackground(slotDraw, -1, -1);
        builder.addSlot(RecipeIngredientRole.INPUT, 80, 15).addItemStacks(getInput(inputs, 3)).setBackground(slotDraw, -1, -1);
        builder.addSlot(RecipeIngredientRole.INPUT, 100, 35).addItemStacks(getInput(inputs, 4)).setBackground(slotDraw, -1, -1);
        builder.addSlot(RecipeIngredientRole.INPUT, 100, 55).addItemStacks(getInput(inputs, 5)).setBackground(slotDraw, -1, -1);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 140, 5).addItemStack(output).setBackground(slotDraw, -1, -1);
    }

    private List<class_1799> getInput(List<List<class_1799>> inputs, int index) {
        if (index < inputs.size()) {
            return inputs.get(index);
        }
        return Collections.singletonList(class_1799.field_8037);
    }

    @Override
    public RecipeType<AltarRecipeWrapper> getRecipeType() {
        return ALTAR;
    }

    @Override
    public class_2561 getTitle() {
        return TITLE;
    }

    @Override
    @SuppressWarnings("removal")
    public IDrawable getBackground() {
        return bgDraw;
    }

    @Override
    public IDrawable getIcon() {
        return altarDraw;
    }
}
