package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

/**
 * MaidShootTargetAnyItemTask 的升级版本，不限制手持物品必须是 ProjectileWeaponItem
 */
public class MaidShootTargetAnyItemTask extends class_4097<EntityMaid> {
    private final int attackCooldown;
    private final int chargeDurationTick;
    private final Predicate<class_1799> weaponTest;
    private int attackTime = -1;
    private int seeTime;
    private int swingTime;

    public MaidShootTargetAnyItemTask(int attackCooldown, int chargeDurationTick, Predicate<class_1799> weaponTest) {
        super(ImmutableMap.of(class_4140.field_18446, class_4141.field_18458,
                class_4140.field_22355, class_4141.field_18456), 1200);
        this.attackCooldown = attackCooldown;
        this.chargeDurationTick = chargeDurationTick;
        this.weaponTest = weaponTest;
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        Optional<class_1309> memory = owner.method_18868().method_18904(class_4140.field_22355);
        if (memory.isPresent()) {
            class_1309 target = memory.get();
            return owner.method_24520(weaponTest) && owner.canSee(target);
        }
        return false;
    }

    @Override
    protected boolean canStillUse(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.method_18868().method_18896(class_4140.field_22355) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    @Override
    protected void tick(class_3218 worldIn, EntityMaid owner, long gameTime) {
        owner.method_18868().method_18904(class_4140.field_22355).ifPresent((target) -> {
            // 强行看见并朝向
            owner.method_5988().method_20248(target.method_23317(), target.method_23318(), target.method_23321());
            boolean canSee = owner.canSee(target);
            boolean seeTimeMoreThanZero = this.seeTime > 0;

            // 如果两者不一致，重置看见时间
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            // 如果看见了对方，增加看见时间，否则减少
            if (canSee) {
                ++this.seeTime;
            } else {
                --this.seeTime;
            }

            // 依据是否可以 use 物品，分别判断
            boolean itemCanNotUse = owner.method_6047().method_7935() <= 0;
            if (itemCanNotUse) {
                tickItemCanNotUse(owner, target, canSee);
            } else {
                // 如果实体手部处于激活状态
                tickItemCanUse(owner, target, canSee);
            }
        });
    }

    private void tickItemCanUse(EntityMaid owner, class_1309 target, boolean canSee) {
        if (owner.method_6115()) {
            // 如果看不见对方超时 60，重置激活状态
            if (!canSee && this.seeTime < -60) {
                owner.method_6021();
            } else if (canSee) {
                // 否则开始进行远程攻击
                int ticksUsingItem = owner.method_6048();
                if (ticksUsingItem >= this.chargeDurationTick) {
                    owner.method_6021();
                    int powerTime = Math.max(ticksUsingItem, 20);
                    owner.method_7105(target, class_1753.method_7722(powerTime));
                    this.attackTime = this.attackCooldown;
                }
            }
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            // 非激活状态，但是时长合适，开始激活手部
            owner.method_6019(class_1268.field_5808);
        }
    }

    private void tickItemCanNotUse(EntityMaid owner, class_1309 target, boolean canSee) {
        if (owner.isSwingingArms()) {
            if (!canSee && this.seeTime < -60) {
                owner.setSwingingArms(false);
                swingTime = 0;
            } else if (canSee) {
                if (swingTime >= this.chargeDurationTick) {
                    int powerTime = Math.max(swingTime, 20);
                    owner.method_7105(target, class_1753.method_7722(powerTime));
                    this.attackTime = this.attackCooldown;
                    owner.setSwingingArms(false);
                    swingTime = 0;
                }
            }
            swingTime++;
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            owner.setSwingingArms(true);
        }
    }

    @Override
    protected void stop(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.seeTime = 0;
        this.attackTime = -1;
        this.swingTime = 0;
        entityIn.method_6021();
    }
}