package com.github.tartaricacid.touhoulittlemaid.entity.ai.goal;

import com.github.tartaricacid.touhoulittlemaid.datagen.tag.EntityTypeGenerator;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1405;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_4051;
import java.util.EnumSet;
import java.util.List;

public class FairyNearestAttackableTargetGoal<T extends class_1309> extends class_1405 {
    private static final int DEFAULT_RANDOM_INTERVAL = 5;
    private final class_4051 targetConditions;
    private @Nullable class_1309 target;

    public FairyNearestAttackableTargetGoal(EntityFairy fairy) {
        super(fairy, true, false);
        this.method_6265(EnumSet.of(class_4134.field_18408));
        this.targetConditions = class_4051.method_36625().method_18418(this.method_6326());
    }

    @Override
    public boolean method_6264() {
        if (this.field_6660.method_6051().method_43048(DEFAULT_RANDOM_INTERVAL) != 0) {
            return false;
        } else {
            this.findTarget();
            return this.target != null;
        }
    }

    private class_238 getTargetSearchArea(double distance) {
        return this.field_6660.method_5829().method_1009(distance, 4, distance);
    }

    private void findTarget() {
        class_1937 level = this.field_6660.field_6002;
        class_238 searchArea = this.getTargetSearchArea(this.method_6326());
        List<class_1309> entities = level.method_8390(class_1309.class, searchArea,
                e -> e.method_5864().method_20210(EntityTypeGenerator.MAID_FAIRY_ATTACK_GOAL));
        this.target = level.method_18468(entities, this.targetConditions, this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321());
    }

    @Override
    public void method_6269() {
        this.field_6660.method_5980(this.target);
        super.method_6269();
    }
}