package com.github.tartaricacid.touhoulittlemaid.entity.backpack.data;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncFluidAmountMessage;
import com.github.tartaricacid.touhoulittlemaid.util.MaidFluidUtil;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class TankBackpackData extends class_1277 implements IBackpackData {
    public static final long CAPACITY = 10 * FluidConstants.BUCKET;
    private static final int INPUT_INDEX = 0;
    private static final int OUTPUT_INDEX = 1;
    private final EntityMaid maid;
    private final SingleFluidStorage tank = SingleFluidStorage.withFixedCapacity(CAPACITY, () -> {
    });
    private final class_3913 dataAccess = new class_3913() {
        @Override
        public int method_17390(int index) {
            if (index == 0) {
                return (int) TankBackpackData.this.tankFluidCount;
            }
            return 0;
        }

        @Override
        public void method_17391(int index, int value) {
            if (index == 0) {
                TankBackpackData.this.tankFluidCount = value;
            }
        }

        @Override
        public int method_17389() {
            return 1;
        }
    };
    private long tankFluidCount = 0;

    public TankBackpackData(EntityMaid maid) {
        super(2);
        this.maid = maid;
    }

    @Override
    public void method_5447(int index, @NotNull class_1799 stack) {
        if (!this.maid.field_6002.field_9236) {
            CombinedInvWrapper availableInv = this.maid.getAvailableInv(false);
            if (index == INPUT_INDEX) {
                MaidFluidUtil.bucketToTank(stack, tank, availableInv);
            }
            if (index == OUTPUT_INDEX) {
                MaidFluidUtil.tankToBucket(stack, tank, availableInv);
            }
            this.tankFluidCount = tank.amount;
            // amount改变时发包同步客户端流体amount
            if (TankBackpackData.this.maid.method_35057() instanceof class_3222 serverPlayer) {
                ServerPlayNetworking.send(serverPlayer, SyncFluidAmountMessage.ID, SyncFluidAmountMessage.encode(this.maid.method_5628(), (int) this.tankFluidCount));
            }
            class_2960 key = class_7923.field_41173.method_10221(tank.getResource().getFluid());
            maid.setBackpackFluid(key.toString());
        }
        super.method_5447(index, stack);
    }

    @Override
    public int method_5444() {
        return 1;
    }

    @Override
    public class_3913 getDataAccess() {
        return dataAccess;
    }

    @Override
    public void load(class_2487 tag, EntityMaid maid) {
        this.loadTank(tag.method_10562("Tanks"), maid);
        this.method_7659(tag.method_10554("Items", class_2520.field_33260));
    }

    @Override
    public void save(class_2487 tag, EntityMaid maid) {
        class_2487 tankNbt = new class_2487();
        tank.writeNbt(tankNbt);
        tag.method_10566("Tanks", tankNbt);
        tag.method_10566("Items", this.method_7660());
    }

    @Override
    public void serverTick(EntityMaid maid) {
    }

    public SingleFluidStorage getTank() {
        return tank;
    }

    public void loadTank(class_2487 nbt, EntityMaid maid) {
        tank.readNbt(nbt);
        this.tankFluidCount = tank.getAmount();
        class_2960 key = class_7923.field_41173.method_10221(tank.getResource().getFluid());
        maid.setBackpackFluid(key.toString());
    }
}
