package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4215;
import net.minecraft.server.MinecraftServer;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class MaidConfigMessage {
    public static final class_2960 ID = getResourceLocation("maid_config");

    public static class_2540 encode(int id, boolean home, boolean pick, boolean ride, MaidSchedule schedule) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        buf.writeBoolean(home);
        buf.writeBoolean(pick);
        buf.writeBoolean(ride);
        buf.method_10817(schedule);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int id = buf.readInt();
        boolean home = buf.readBoolean();
        boolean pick = buf.readBoolean();
        boolean ride = buf.readBoolean();
        MaidSchedule schedule = buf.method_10818(MaidSchedule.class);
        server.execute(() -> {
            class_1297 entity = player.field_6002.method_8469(id);
            if (entity instanceof EntityMaid maid && maid.method_6171(player)) {
                if (maid.isHomeModeEnable() != home) {
                    handleHome(id, home, pick, ride, schedule, player, maid);
                }
                if (maid.isPickup() != pick) {
                    maid.setPickup(pick);
                }
                if (maid.isRideable() != ride) {
                    maid.setRideable(ride);
                    class_1297 vehicle = maid.method_5854();
                    if (!ride && vehicle != null && !isStopRideBlocklist(vehicle)) {
                        maid.method_5848();
                    }
                }
                if (maid.getSchedule() != schedule) {
                    maid.setSchedule(schedule);
                    maid.getSchedulePos().restrictTo(maid);
                    if (maid.isHomeModeEnable()) {
                        class_4215.method_24561(maid, maid.method_18412(), 0.7f, 3);
                    }
                    if (maid.method_35057() instanceof class_3222 serverPlayer) {
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.SWITCH_SCHEDULE);
                    }
                }
            }
        });
    }

    private static boolean isStopRideBlocklist(class_1297 vehicle) {
        // 娱乐方块骑乘不受影响
        boolean isSit = vehicle instanceof EntitySit;
        // 飞行中的扫帚不能脱离，有风险
        boolean isBroom = vehicle instanceof EntityBroom broom && !broom.method_24828();
        return isSit || isBroom;
    }

    private static void handleHome(int id, boolean home, boolean pick, boolean ride, MaidSchedule schedule, class_3222 player, EntityMaid maid) {
        if (home) {
            SchedulePos schedulePos = maid.getSchedulePos();
            if (schedulePos.isConfigured()) {
                class_2960 dimension = schedulePos.getDimension();
                if (!dimension.equals(maid.field_6002.method_27983().method_29177())) {
                    class_2540 buf = CheckScheduleMessage.encode("message.touhou_little_maid.check_schedule_pos.dimension");
                    ServerPlayNetworking.send(player, CheckScheduleMessage.ID, buf);
                    return;
                }
                class_2338 nearestPos = schedulePos.getNearestPos(maid);
                if (nearestPos != null && nearestPos.method_10262(maid.method_24515()) > 32 * 32) {
                    class_2540 buf = CheckScheduleMessage.encode("message.touhou_little_maid.check_schedule_pos.too_far");
                    ServerPlayNetworking.send(player, CheckScheduleMessage.ID, buf);
                    return;
                }
            }
            schedulePos.setHomeModeEnable(maid, maid.method_24515());
        } else {
            maid.method_18408(class_2338.field_10980, MaidConfig.MAID_NON_HOME_RANGE.get());
        }
        maid.setHomeModeEnable(home);
    }

}