package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class YsmMaidModelMessage {
    public static final class_2960 ID = getResourceLocation("ysm_maid_model");

    public static class_2540 encode(int maidId, String modeId, String texture, class_2561 name) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(maidId);
        buf.method_10814(modeId);
        buf.method_10814(texture);
        buf.method_10805(name);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 sender, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int maidId = buf.readInt();
        String modeId = buf.method_19772();
        String texture = buf.method_19772();
        class_2561 name = buf.method_10808();
        server.execute(() -> {
            class_1297 entity = sender.field_6002.method_8469(maidId);
            if (entity instanceof EntityMaid maid && maid.method_6171(sender)) {
                if (sender.method_7337() || MaidConfig.MAID_CHANGE_MODEL.get()) {
                    maid.setIsYsmModel(true);
                    maid.setYsmModel(modeId, texture, name);
                    InitTrigger.MAID_EVENT.trigger(sender, TriggerType.CHANGE_MAID_MODEL);
                } else {
                    sender.method_43496(class_2561.method_43471("message.touhou_little_maid.change_model.disabled"));
                }
            }
        });
    }
}
