/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.DirectButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveSwitcherDataMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5250;

public class ModelSwitcherGui
extends class_437 {
    private static final class_2960 BG = new class_2960("touhou_little_maid", "textures/gui/model_switcher.png");
    private static final class_2960 DEFAULT_MODEL_ID = new class_2960("touhou_little_maid:hakurei_reimu");
    private final List<TileEntityModelSwitcher.ModeInfo> infoList;
    private final class_2338 pos;
    private final int maxRow = 6;
    private final UUID bindUuid;
    protected int imageWidth = 256;
    protected int imageHeight = 166;
    protected int leftPos;
    protected int topPos;
    private EntityMaid maid = null;
    private class_342 description;
    private int selectedIndex = -1;
    private int page;

    public ModelSwitcherGui(TileEntityModelSwitcher switcher) {
        super((class_2561)class_2561.method_43470((String)"Model Switcher GUI"));
        this.infoList = switcher.getInfoList();
        this.pos = switcher.method_11016();
        this.bindUuid = switcher.getUuid();
        if (class_310.method_1551().field_1687 != null) {
            this.maid = new EntityMaid((class_1937)class_310.method_1551().field_1687);
        }
    }

    protected void method_25426() {
        this.method_37067();
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.selectedIndex = this.selectedIndex < this.infoList.size() ? this.selectedIndex : -1;
        this.page = this.page <= (this.infoList.size() - 1) / 6 ? this.page : 0;
        this.addListChangeButton();
        this.addPageButton();
        this.addListButton();
        if (this.selectedIndex >= 0) {
            this.addEditButton();
        } else {
            this.description = null;
        }
    }

    private void addEditButton() {
        TileEntityModelSwitcher.ModeInfo info = this.infoList.get(this.selectedIndex);
        this.maid.setModelId(info.getModelId().toString());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.button.skin"), b -> CacheIconManager.openModelSwitcherModelGui(this.maid, info, this)).method_46433(this.leftPos + 55, this.topPos + 15).method_46437(76, 20).method_46431());
        this.method_37063((class_364)new DirectButton(this.leftPos + 55, this.topPos + 38, 76, 20, info.getDirection(), b -> info.setDirection(((DirectButton)b).getDirection())));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectWorld.edit.save"), b -> ClientPlayNetworking.send((class_2960)SaveSwitcherDataMessage.ID, (class_2540)SaveSwitcherDataMessage.encode(this.pos, this.infoList))).method_46433(this.leftPos + 12, this.topPos + 135).method_46437(121, 20).method_46431());
        this.description = new class_342(Screens.getTextRenderer((class_437)this), this.leftPos + 12, this.topPos + 65, 119, 20, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.name_tag.edit_box"));
        this.description.method_1852(info.getText());
        this.method_25429((class_364)this.description);
        this.method_48265((class_364)this.description);
    }

    private void addListButton() {
        int startOffsetY = this.topPos + 24;
        for (int i = this.page * 6; i < Math.min(this.infoList.size(), (this.page + 1) * 6); ++i) {
            ImageButtonWithId button = i != this.selectedIndex ? new ImageButtonWithId(i, this.leftPos + 141, startOffsetY, 108, 19, 0, 166, 19, BG, b -> {
                this.selectedIndex = ((ImageButtonWithId)b).getIndex();
                this.method_25426();
            }) : new ImageButtonWithId(i, this.leftPos + 141, startOffsetY, 108, 19, 108, 166, 0, BG, b -> {
                this.selectedIndex = -1;
                this.method_25426();
            });
            this.method_37063((class_364)button);
            startOffsetY += 19;
        }
    }

    private void addPageButton() {
        this.method_37063((class_364)new TouhouImageButton(this.leftPos + 141, this.topPos + 7, 13, 16, 0, 204, 16, BG, b -> {
            if (this.page > 0) {
                --this.page;
                this.method_25426();
            }
        }));
        this.method_37063((class_364)new TouhouImageButton(this.leftPos + 236, this.topPos + 7, 13, 16, 13, 204, 16, BG, b -> {
            if (this.page + 1 <= (this.infoList.size() - 1) / 6) {
                ++this.page;
                this.method_25426();
            }
        }));
    }

    private void addListChangeButton() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.model_switcher.list.add"), b -> {
            this.infoList.add(new TileEntityModelSwitcher.ModeInfo(DEFAULT_MODEL_ID, "", class_2350.field_11043));
            this.method_25426();
        }).method_46433(this.leftPos + 141, this.topPos + 139).method_46437(53, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectWorld.deleteButton"), b -> {
            if (-1 < this.selectedIndex && this.selectedIndex < this.infoList.size()) {
                this.infoList.remove(this.selectedIndex);
                this.selectedIndex = -1;
                this.method_25426();
            }
        }).method_46433(this.leftPos + 196, this.topPos + 139).method_46437(53, 20).method_46431());
    }

    public void method_25410(class_310 pMinecraft, int pWidth, int pHeight) {
        String value = "";
        if (this.description != null) {
            value = this.description.method_1882();
        }
        super.method_25410(pMinecraft, pWidth, pHeight);
        if (this.description != null) {
            this.description.method_1852(value);
        }
    }

    public void method_25394(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.maid == null) {
            return;
        }
        this.method_25420(graphics);
        if (this.bindUuid != null) {
            graphics.method_25300(this.field_22793, this.bindUuid.toString(), this.leftPos + 128, this.topPos - 10, 0xFFFFFF);
        } else {
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.model_switcher.uuid.empty"), this.leftPos + 128, this.topPos - 10, 0xFFFFFF);
        }
        graphics.method_25300(this.field_22793, String.format("%d/%d", this.page + 1, (this.infoList.size() - 1) / 6 + 1), this.leftPos + 193, this.topPos + 12, 0xFFFFFF);
        if (this.description != null) {
            class_490.method_2486((class_332)graphics, (int)(this.leftPos + 30), (int)(this.topPos + 60), (int)25, (float)-25.0f, (float)-20.0f, (class_1309)this.maid);
            this.description.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
        }
        super.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderListButtonName(graphics);
    }

    private void renderListButtonName(class_332 graphics) {
        int startOffsetY = this.topPos + 29;
        for (int i = this.page * 6; i < Math.min(this.infoList.size(), (this.page + 1) * 6); ++i) {
            String modelId = this.infoList.get(i).getModelId().toString();
            if (CustomPackLoader.MAID_MODELS.getInfo(modelId).isPresent()) {
                MaidModelInfo info = CustomPackLoader.MAID_MODELS.getInfo(modelId).get();
                class_5250 component = class_2561.method_43471((String)ParseI18n.getI18nKey(info.getName()));
                graphics.method_27534(this.field_22793, (class_2561)component, this.leftPos + 193, startOffsetY, 0xFFFFFF);
            }
            startOffsetY += 19;
        }
    }

    public void method_25393() {
        if (this.description != null && 0 <= this.selectedIndex && this.selectedIndex < this.infoList.size()) {
            this.infoList.get(this.selectedIndex).setText(this.description.method_1882());
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.description != null && this.description.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.description);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void method_25415(String text, boolean overwrite) {
        if (this.description != null) {
            if (overwrite) {
                this.description.method_1852(text);
            } else {
                this.description.method_1867(text);
            }
        }
    }

    public void method_25419() {
        ClientPlayNetworking.send((class_2960)SaveSwitcherDataMessage.ID, (class_2540)SaveSwitcherDataMessage.encode(this.pos, this.infoList));
        super.method_25419();
    }
}

