/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1088;
import net.minecraft.class_1308;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2499;
import net.minecraft.class_2573;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5599;
import net.minecraft.class_6880;
import net.minecraft.class_7833;

public class GeckoLayerMaidBanner<T extends class_1308, R extends IGeoEntityRenderer<T>>
extends GeoLayerRenderer<T, R> {
    private static final class_2960 TEXTURE = new class_2960("touhou_little_maid", "textures/bedrock/entity/maid_banner.png");
    private final SimpleBedrockModel<EntityMaid> bannerModel;
    private final class_5599 modelSet;

    public GeckoLayerMaidBanner(R renderer, class_5599 modelSet) {
        super(renderer);
        this.modelSet = modelSet;
        this.bannerModel = Objects.requireNonNull(BedrockModelLoader.getModel(BedrockModelLoader.MAID_BANNER));
    }

    @Override
    public GeoLayerRenderer<T, R> copy(R entityRendererIn) {
        return new GeckoLayerMaidBanner<T, R>(entityRendererIn, this.modelSet);
    }

    @Override
    public void render(class_4587 poseStack, class_4597 bufferIn, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        class_1792 class_17922;
        EntityMaid maid = IMaid.convertToMaid(entity);
        if (maid == null || !((class_17922 = maid.getBackpackShowItem().method_7909()) instanceof class_1746)) {
            return;
        }
        class_1746 bannerItem = (class_1746)class_17922;
        if (!this.getGeoEntity(entity).getMaidInfo().isShowBackpack() || entity.method_6113() || entity.method_5767()) {
            return;
        }
        if (!maid.getConfigManager().isShowBackItem()) {
            return;
        }
        ILocationModel geoModel = this.getLocationModel(entity);
        if (geoModel != null && !geoModel.backpackBones().isEmpty()) {
            poseStack.method_22903();
            RenderUtils.prepMatrixForLocator(poseStack, geoModel.backpackBones());
            poseStack.method_22904(0.0, 0.75, 0.3);
            poseStack.method_22905(0.65f, -0.65f, -0.65f);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
            poseStack.method_22907(class_7833.field_40713.rotationDegrees(5.0f));
            class_4588 buffer = bufferIn.getBuffer(class_1921.method_23572((class_2960)TEXTURE));
            this.bannerModel.method_2828(poseStack, buffer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            List list = class_2573.method_24280((class_1767)bannerItem.method_7706(), (class_2499)class_2573.method_24281((class_1799)maid.getBackpackShowItem()));
            this.renderPatterns(poseStack, bufferIn, packedLight, this.bannerModel.getPart("banner"), list);
            poseStack.method_22909();
        }
    }

    private void renderPatterns(class_4587 poseStack, class_4597 bufferSource, int packedLight, BedrockPart banner, List<Pair<class_6880<class_2582>, class_1767>> patterns) {
        banner.render(poseStack, class_1088.field_20847.method_30001(bufferSource, class_1921::method_23572, false), packedLight, class_4608.field_21444);
        for (int index = 0; index < 17 && index < patterns.size(); ++index) {
            Pair<class_6880<class_2582>, class_1767> patternPair = patterns.get(index);
            float[] colorComponents = ((class_1767)patternPair.getSecond()).method_7787();
            ((class_6880)patternPair.getFirst()).method_40230().map(class_4722::method_33081).ifPresent(material -> banner.render(poseStack, material.method_24145(bufferSource, class_1921::method_23588), packedLight, class_4608.field_21444, colorComponents[0], colorComponents[1], colorComponents[2], 1.0f));
        }
    }
}

