/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidMoveToBlockTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class MaidFarmMoveTask
extends MaidMoveToBlockTask {
    private static final int MAX_ITEMS = 8;
    private final class_2371<class_1799> seeds = class_2371.method_10211();
    private final IFarmTask task;
    private long chatBubbleKey = -1L;

    public MaidFarmMoveTask(IFarmTask task, float movementSpeed) {
        super(movementSpeed, 2);
        this.task = task;
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        if (super.checkExtraStartConditions(worldIn, owner)) {
            if (this.getItemEntityCount(worldIn, owner) < 8) {
                return true;
            }
            this.chatBubbleKey = owner.getChatBubbleManager().addTextChatBubbleIfTimeout("chat_bubble.touhou_little_maid.inner.farm.too_many_item_entities", this.chatBubbleKey);
            return false;
        }
        return false;
    }

    private int getItemEntityCount(class_3218 worldIn, EntityMaid maid) {
        float radius = maid.method_18413();
        class_238 aabb = maid.method_18410() ? new class_238(maid.method_18412()).method_1009((double)radius, 4.0, (double)radius) : maid.method_5829().method_1009((double)radius, 4.0, (double)radius);
        return worldIn.method_8390(class_1297.class, aabb, class_1297::method_5805).size();
    }

    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.seeds.clear();
        CombinedInvWrapper inv = entityIn.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); ++i) {
            class_1799 stack = inv.getStackInSlot(i);
            if (!this.task.isSeed(stack)) continue;
            this.seeds.add((Object)stack);
        }
        this.searchForDestination(worldIn, entityIn);
    }

    @Override
    protected boolean shouldMoveTo(class_3218 worldIn, EntityMaid maid, class_2338 basePos) {
        class_2680 cropState;
        class_2338 above2Pos;
        class_2680 stateUp2;
        if (this.task.checkCropPosAbove() && !(stateUp2 = worldIn.method_8320(above2Pos = basePos.method_10086(2))).method_26220((class_1922)worldIn, above2Pos).method_1110()) {
            return false;
        }
        class_2338 cropPos = basePos.method_10084();
        if (this.task.canHarvest(maid, cropPos, cropState = worldIn.method_8320(cropPos))) {
            return true;
        }
        class_2680 baseState = worldIn.method_8320(basePos);
        return this.seeds.stream().anyMatch(seed -> this.task.canPlant(maid, basePos, baseState, (class_1799)seed));
    }
}

