package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.IContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.function.ContextFunction;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.MolangUtils;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.ExecutionContext;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class EffectLevel extends ContextFunction<class_1297> {
    @Override
    public boolean validateArgumentSize(int size) {
        return size == 1;
    }

    @Override
    protected Object eval(ExecutionContext<IContext<class_1297>> context, ArgumentCollection arguments) {
        class_2960 effectId = MolangUtils.parseResourceLocation(context.entity(), arguments.getAsString(context, 0));
        if (effectId == null) {
            return null;
        }

        Optional<class_1291> effect = class_7923.field_41174.method_17966(effectId);
        if (effect.isEmpty()) {
            return 0;
        }

        if (context.entity().entity() instanceof class_1309) {
            class_1293 instance = ((class_1309) context.entity().entity()).method_6112(effect.get());
            if (instance != null) {
                return instance.method_5578() + 1;
            }
        } else {
            return null;
        }

        return 0;
    }
}
