package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.functions;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.IContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.function.entity.LivingEntityFunction;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.MolangUtils;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.ExecutionContext;
import com.github.tartaricacid.touhoulittlemaid.util.EquipmentUtil;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class EquippedEnchantmentLevel extends LivingEntityFunction {
    @Override
    protected Object eval(ExecutionContext<IContext<class_1309>> context, ArgumentCollection arguments) {
        class_1304 slotType = MolangUtils.parseSlotType(context.entity(), arguments.getAsString(context, 0));
        if (slotType == null) {
            return null;
        }

        class_2960 id = MolangUtils.parseResourceLocation(context.entity(), arguments.getAsString(context, 1));
        if (id == null) {
            return null;
        }

        class_1887 enchantment = class_7923.field_41176.method_10223(id);
        if (enchantment == null) {
            return 0;
        }

        class_1799 itemStack = EquipmentUtil.getEquippedItem(context.entity().entity(), slotType);
        if (itemStack.method_7960()) {
            return 0;
        }

        return class_1890.method_8225(enchantment, itemStack);
    }

    @Override
    public boolean validateArgumentSize(int size) {
        return size == 2;
    }
}
