package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendNameTagMessage;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.apache.commons.lang3.StringUtils;

public class NameTagGui extends class_437 {
    private static final class_2960 TEXTURES = new class_2960("textures/gui/container/beacon.png");
    private final EntityMaid maid;
    private class_342 textField;
    private class_4185 alwaysShowButton;
    private boolean alwaysShow = false;

    public NameTagGui(EntityMaid maid) {
        super(class_2561.method_43473());
        this.maid = maid;
    }

    @Override
    protected void method_25426() {
        this.method_37067();
        int middleX = this.field_22789 / 2;
        int middleY = this.field_22790 / 2;
        textField = new class_342(Screens.getTextRenderer(this), middleX - 99, middleY - 26, 176, 20,
                class_2561.method_43471("gui.touhou_little_maid.name_tag.edit_box"));
        this.method_25429(this.textField);
        this.method_48265(this.textField);
        this.method_37063(class_4185.method_46430(class_2561.method_43471("gui.done"), this::sendDoneMessage)
                .method_46433(middleX - 100, middleY).method_46437(98, 20).method_46431());
        this.method_37063(class_4185.method_46430(class_2561.method_43471("gui.cancel"), b -> method_25419())
                .method_46433(middleX + 2, middleY).method_46437(98, 20).method_46431());
        alwaysShowButton = class_4185.method_46430(class_2561.method_43473(), b -> alwaysShow = !alwaysShow)
                .method_46433(middleX + 80, middleY - 26).method_46437(20, 20).method_46431();
        method_37063(alwaysShowButton);
    }

    @Override
    public void method_25410(class_310 minecraft, int width, int height) {
        String value = this.textField.method_1882();
        super.method_25410(minecraft, width, height);
        this.textField.method_1852(value);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int middleX = this.field_22789 / 2;
        int middleY = this.field_22790 / 2;
        method_25420(graphics);
        textField.method_25394(graphics, mouseX, mouseY, partialTicks);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25302(TEXTURES, middleX + 80, middleY - 26, alwaysShow ? 88 : 110, 220, 20, 20);
        if (alwaysShowButton.method_49606()) {
            graphics.method_51438(field_22793, class_2561.method_43471("gui.touhou_little_maid.tag.always_show"), mouseX, mouseY);
        }
    }

    @Override
    public void method_25393() {
        this.textField.method_1865();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.textField.method_25402(mouseX, mouseY, button)) {
            this.method_25395(this.textField);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    protected void method_25415(String text, boolean overwrite) {
        if (overwrite) {
            this.textField.method_1852(text);
        } else {
            this.textField.method_1867(text);
        }
    }

    private void sendDoneMessage(class_4185 button) {
        if (StringUtils.isNotBlank(textField.method_1882())) {
            ClientPlayNetworking.send(SendNameTagMessage.ID, SendNameTagMessage.encode(maid.method_5628(), textField.method_1882(), alwaysShow));
        }
        this.method_25419();
    }
}