package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.task.AttackTaskConfigGui;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class MonsterListButton extends class_4185 {
    private static final class_2960 ICON = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/attack_task_config.png");
    private final AttackTaskConfigGui parents;
    private final class_2960 entityId;

    public MonsterListButton(class_2561 entityName, int x, int y, class_2960 entityId, AttackTaskConfigGui parents) {
/*        super(Button.builder(entityName, b -> {
        }).pos(x, y).size(164, 13));*/
        super(x, y, 164, 13, entityName, b -> {
        }, class_4185.field_40754);
        this.parents = parents;
        this.entityId = entityId;
    }

    @Override
    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float pPartialTick) {
        class_310 mc = class_310.method_1551();
        RenderSystem.enableDepthTest();
        if (deleteClick(mouseX, mouseY)) {
            graphics.method_25290(ICON, this.method_46426(), this.method_46427(), 0, 163, this.field_22758, this.field_22759, 256, 256);
        } else if (leftClick(mouseX, mouseY) || rightClick(mouseX, mouseY)) {
            graphics.method_25290(ICON, this.method_46426(), this.method_46427(), 0, 150, this.field_22758, this.field_22759, 256, 256);
        } else {
            graphics.method_25290(ICON, this.method_46426(), this.method_46427(), 0, 137, this.field_22758, this.field_22759, 256, 256);
        }
        graphics.method_51439(mc.field_1772, this.method_25369(), this.method_46426() + 5, this.method_46427() + 3, 0x444444, false);
        graphics.method_27534(mc.field_1772, this.parents.getAttackGroups().get(entityId).getComponent(), this.method_46426() + 142, this.method_46427() + 3, 0xFFFFFF);
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        if (deleteClick(mouseX, mouseY)) {
            this.parents.removeMonsterType(this.entityId);
        } else if (leftClick(mouseX, mouseY)) {
            this.parents.getAttackGroups().computeIfPresent(this.entityId, (k, monsterType) -> monsterType.getPrevious());
        } else if (rightClick(mouseX, mouseY)) {
            this.parents.getAttackGroups().computeIfPresent(this.entityId, (k, monsterType) -> monsterType.getNext());
        }
    }

    private boolean deleteClick(double mouseX, double mouseY) {
        boolean clickY = this.method_46427() <= mouseY && mouseY <= (this.method_46427() + this.method_25364());
        boolean deleteClickX = (this.method_46426() + 107) <= mouseX && mouseX <= (this.method_46426() + 120);
        return clickY && deleteClickX;
    }

    private boolean leftClick(double mouseX, double mouseY) {
        boolean clickY = this.method_46427() <= mouseY && mouseY <= (this.method_46427() + this.method_25364());
        boolean leftClickX = (this.method_46426() + 120) <= mouseX && mouseX <= (this.method_46426() + 130);
        return clickY && leftClickX;
    }

    private boolean rightClick(double mouseX, double mouseY) {
        boolean clickY = this.method_46427() <= mouseY && mouseY <= (this.method_46427() + this.method_25364());
        boolean rightClickX = (this.method_46426() + 154) <= mouseX && mouseX <= (this.method_46426() + 164);
        return clickY && rightClickX;
    }
}
