package com.github.tartaricacid.touhoulittlemaid.compat.ponder;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.registration.PonderSceneRegistrationHelper;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class MaidPonderScenes {
    public static void register(PonderSceneRegistrationHelper<class_2960> registrationHelper) {
        PonderSceneRegistrationHelper<class_1792> helper = registrationHelper.withKeyFunction(class_7923.field_41178::method_10221);

        helper.forComponents(InitItems.HAKUREI_GOHEI, InitItems.SANAE_GOHEI)
                .addStoryBoard("altar", MaidPonderScenes::altar);
    }

    public static void altar(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("altar", "How to build an altar");
        scene.scaleSceneView(0.5f);
        scene.showBasePlate();

        for (int i = 1; i < 7; i++) {
            scene.world().showSection(util.select().layer(i), class_2350.field_11033);
            scene.addKeyframe();
            scene.idle(10);
        }

        class_2338 pos = new class_2338(5, 4, 1);
        Selection clickPos = util.select().position(pos);

        scene.overlay().showOutlineWithText(clickPos, 50)
                .colored(PonderPalette.BLUE)
                .placeNearTarget()
                .pointAt(util.vector().blockSurface(pos, class_2350.field_11043, 0.25f))
                .text("Use Gohei click here to build the altar");

        scene.idle(60);

        scene.overlay().showOutlineWithText(clickPos, 50)
                .colored(PonderPalette.BLUE)
                .placeNearTarget()
                .pointAt(util.vector().blockSurface(pos, class_2350.field_11043, 0.25f))
                .text("Paying attention to the direction of the click");
    }
}