package com.github.tartaricacid.touhoulittlemaid.compat.tacz.task;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.tacz.ai.GunAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.compat.tacz.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUseShieldTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_7893;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;

import static com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask.targetConditionsTest;

public class TaskGunAttack implements IRangedAttackTask {
    public static final class_2960 UID = new class_2960(TouhouLittleMaid.MOD_ID, "gun_attack");
    private class_1799 icon;

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        class_2960 gunId = new class_2960(GunMod.MOD_ID, "glock_17");
        if (icon == null) {
            TimelessAPI.getCommonGunIndex(gunId).ifPresentOrElse(index -> this.icon = GunItemBuilder.create().setId(gunId).build(),
                    () -> this.icon = InitItems.TACZ_GUN_ICON.method_7854());
        }
        return this.icon;
    }

    @Nullable
    @Override
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, InitSounds.MAID_RANGE_ATTACK, 0.5f);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return false;
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893<EntityMaid> supplementedTask = class_4824.method_47120(this::mainhandHoldGun, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893<EntityMaid> findTargetTask = class_4828.method_47138(target -> !mainhandHoldGun(maid) || farAway(target, maid));
        class_7893<EntityMaid> gunWalkTargetTask = MaidRangedWalkToTarget.create(0.6f);
        class_7893<EntityMaid> gunAttackStrafingTask = new GunAttackStrafingTask();
        class_7893<EntityMaid> gunShootTargetTask = new GunShootTargetTask();
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();

        return Lists.newArrayList(
                Pair.of(5, supplementedTask),
                Pair.of(5, findTargetTask),
                Pair.of(5, gunWalkTargetTask),
                Pair.of(5, gunAttackStrafingTask),
                Pair.of(5, gunShootTargetTask),
                Pair.of(5, maidUseShieldTask)
        );
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893<EntityMaid> supplementedTask = class_4824.method_47120(this::mainhandHoldGun, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893<EntityMaid> findTargetTask = class_4828.method_47138(target -> !mainhandHoldGun(maid) || farAway(target, maid));
        class_7893<EntityMaid> gunShootTargetTask = new GunShootTargetTask();

        return Lists.newArrayList(
                Pair.of(5, supplementedTask),
                Pair.of(5, findTargetTask),
                Pair.of(5, gunShootTargetTask)
        );
    }

    @Override
    public class_238 searchDimension(EntityMaid maid) {
        if (IGun.mainhandHoldGun(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.method_18410()) {
                return new class_238(maid.method_18412()).method_1014(searchRange);
            } else {
                return maid.method_5829().method_1014(searchRange);
            }
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return MaidConfig.MAID_GUN_LONG_DISTANCE.get();
    }

    @Override
    public boolean canSee(EntityMaid maid, class_1309 target) {
        class_1799 handItem = maid.method_6047();
        IGun iGun = IGun.getIGunOrNull(handItem);
        if (iGun != null) {
            class_2960 gunId = iGun.getGunId(handItem);
            return TimelessAPI.getCommonGunIndex(gunId).map(index -> {
                String type = index.getType();
                // 狙击枪？用远距离模式
                String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
                if (sniper.equals(type)) {
                    return targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
                }
                // 霰弹枪？手枪？冲锋枪？近距离模式
                String shotgun = GunTabType.SHOTGUN.name().toLowerCase(Locale.ENGLISH);
                String pistol = GunTabType.PISTOL.name().toLowerCase(Locale.ENGLISH);
                String smg = GunTabType.SMG.name().toLowerCase(Locale.ENGLISH);
                if (shotgun.equals(type) || pistol.equals(type) || smg.equals(type)) {
                    return targetConditionsTest(maid, target, MaidConfig.MAID_GUN_NEAR_DISTANCE);
                }
                // 其他情况，中等距离
                return targetConditionsTest(maid, target, MaidConfig.MAID_GUN_MEDIUM_DISTANCE);
            }).orElse(IRangedAttackTask.super.canSee(maid, target));
        }
        return IRangedAttackTask.super.canSee(maid, target);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of("has_tacz_gun", this::mainhandHoldGun));
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        return stack.method_7909() instanceof IGun;
    }

    private boolean mainhandHoldGun(EntityMaid maid) {
        return IGun.mainhandHoldGun(maid);
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        return maid.method_5739(target) > this.searchRadius(maid);
    }

    /**
     * 枪械射击不走原版那套逻辑，故此方法为空
     */
    @Override
    public void performRangedAttack(EntityMaid shooter, class_1309 target, float distanceFactor) {
    }
}
