package com.github.tartaricacid.touhoulittlemaid.crafting;

import cn.sh1rocu.touhoulittlemaid.util.forge.RecipeMatcher;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.inventory.AltarRecipeInventory;
import com.google.common.base.Preconditions;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.world.entity.*;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nullable;
import java.util.Objects;

import static com.github.tartaricacid.touhoulittlemaid.inventory.AltarRecipeInventory.RECIPES_SIZE;

public class AltarRecipe implements class_1860<AltarRecipeInventory> {
    private final class_2960 id;
    private final class_1299<?> entityType;
    @Nullable
    private final class_2487 extraData;
    private final float powerCost;
    private final class_2371<class_1856> inputs;
    private final boolean isItemCraft;
    private final class_1799 resultItem;
    private final class_1856 copyInput;
    @Nullable
    private final String copyTag;

    public AltarRecipe(class_2960 id, class_1299<?> entityType, @Nullable class_2487 extraData, float powerCost, class_1856 copyInput, @Nullable String copyTag, class_1856... inputs) {
        Preconditions.checkArgument(0 < inputs.length && inputs.length <= RECIPES_SIZE, "Ingredients count is illegal!");
        this.id = id;
        this.entityType = entityType;
        this.isItemCraft = (entityType == class_1299.field_6052);
        if (this.isItemCraft && extraData != null) {
            this.resultItem = class_1799.method_7915(extraData.method_10562("Item"));
        } else {
            this.resultItem = class_1799.field_8037;
        }
        this.copyInput = copyInput;
        this.copyTag = copyTag;
        this.extraData = extraData;
        this.powerCost = powerCost;
        this.inputs = class_2371.method_10212(class_1856.field_9017, fillInputs(inputs));
    }

    public AltarRecipe(class_2960 id, class_1299<?> entityType, @Nullable class_2487 extraData, float powerCost, class_1856... inputs) {
        this(id, entityType, extraData, powerCost, class_1856.field_9017, null, inputs);
    }

    @Override
    public boolean matches(AltarRecipeInventory inv, class_1937 worldIn) {
        return RecipeMatcher.findMatches(inv.getItems(), inputs) != null;
    }

    @Override
    public class_1799 assemble(AltarRecipeInventory inv, class_5455 access) {
        return method_8110(access).method_7972();
    }

    @Override
    public boolean method_8113(int width, int height) {
        return false;
    }

    @Override
    public class_2371<class_1856> method_8117() {
        return inputs;
    }

    @Override
    public class_1799 method_8110(class_5455 access) {
        return resultItem;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public class_1865<?> method_8119() {
        return InitRecipes.ALTAR_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return InitRecipes.ALTAR_CRAFTING;
    }

    @Override
    public boolean method_8118() {
        return true;
    }

    @Override
    public class_1799 method_17447() {
        return InitItems.HAKUREI_GOHEI.method_7854();
    }

    public class_1299<?> getEntityType() {
        return entityType;
    }

    @Nullable
    public class_2487 getExtraData() {
        return extraData;
    }

    public float getPowerCost() {
        return powerCost;
    }

    public class_1856 getCopyInput() {
        return copyInput;
    }

    @Nullable
    public String getCopyTag() {
        return copyTag;
    }

    public void spawnOutputEntity(class_3218 world, class_2338 pos, @Nullable AltarRecipeInventory inventory) {
        if (extraData != null) {
            class_2487 nbt = this.extraData.method_10553();
            nbt.method_10582("id", Objects.requireNonNull(class_7923.field_41177.method_10221(entityType)).toString());
            class_1297 resultEntity = class_1299.method_17842(nbt, world, (e) -> {
                e.method_5808(pos.method_10263(), pos.method_10264(), pos.method_10260(), e.method_36454(), e.method_36455());
                this.finalizeSpawn(world, pos, e);
                return e;
            });
            if (resultEntity != null) {
                this.finalizeSpawn(world, pos, resultEntity);
                this.copyIngredientTag(inventory, resultEntity);
                world.method_30736(resultEntity);
            }
            return;
        }
        entityType.method_5894(world, null, (class_1657) null, pos, class_3730.field_16465, true, true);
    }

    private void copyIngredientTag(@Nullable AltarRecipeInventory inventory, class_1297 resultEntity) {
        if (inventory != null && this.copyInput != class_1856.field_9017) {
            class_1799 matchStack = inventory.getMatchIngredient(this.copyInput);
            if (!matchStack.method_7960()) {
                class_2487 data;
                if (StringUtils.isEmpty(this.copyTag)) {
                    data = matchStack.method_7969();
                } else {
                    data = matchStack.method_7941(this.copyTag);
                }
                if (data != null && !data.method_33133()) {
                    if (resultEntity instanceof class_1309 livingEntity) {
                        livingEntity.method_5749(data);
                    }
                    if (resultEntity instanceof class_1542 itemEntity) {
                        itemEntity.method_5749(data);
                    }
                }
            }
        }
    }

    public boolean isItemCraft() {
        return isItemCraft;
    }

    private void finalizeSpawn(class_3218 world, class_2338 pos, @Nullable class_1297 entity) {
        if (entity instanceof class_1308) {
            ((class_1308) entity).method_5943(world, world.method_8404(pos), class_3730.field_16465, null, null);
        }
    }

    private class_1856[] fillInputs(class_1856[] inputs) {
        class_1856[] newInputs = new class_1856[RECIPES_SIZE];
        for (int i = 0; i < RECIPES_SIZE; i++) {
            if (i < inputs.length) {
                newInputs[i] = inputs[i];
            } else {
                newInputs[i] = class_1856.field_9017;
            }
        }
        return newInputs;
    }
}