package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.github.tartaricacid.touhoulittlemaid.util.EntityCraftingHelper;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nullable;
import net.minecraft.class_1299;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import java.util.List;
import java.util.Optional;

public class AltarRecipeSerializer implements class_1865<AltarRecipe> {
    @Override
    public AltarRecipe method_8121(class_2960 recipeId, JsonObject json) {
        EntityCraftingHelper.Output output = EntityCraftingHelper.getEntityData(class_3518.method_15296(json, "output"));
        float powerCost = class_3518.method_15259(json, "power");
        JsonArray ingredients = class_3518.method_15261(json, "ingredients");
        List<class_1856> inputs = Lists.newArrayList();
        for (JsonElement e : ingredients) {
            inputs.add(class_1856.method_52177(e));
        }
        return new AltarRecipe(recipeId, output.getType(), output.getData(), powerCost, output.getCopyInput(), output.getCopyTag(), inputs.toArray(new class_1856[0]));
    }

    @Nullable
    @Override
    public AltarRecipe method_8122(class_2960 recipeId, class_2540 buffer) {
        Optional<class_1299<?>> typeOptional = class_1299.method_5898(buffer.method_19772());
        if (typeOptional.isPresent()) {
            class_1299<?> entityType = typeOptional.get();
            class_2487 extraData = buffer.method_10798();
            float powerCost = buffer.readFloat();
            class_1856 copyInput = class_1856.method_8086(buffer);
            String copyTag = buffer.method_19772();
            class_1856[] inputs = new class_1856[buffer.method_10816()];
            for (int i = 0; i < inputs.length; i++) {
                inputs[i] = class_1856.method_8086(buffer);
            }
            return new AltarRecipe(recipeId, entityType, extraData, powerCost, copyInput, copyTag, inputs);
        }
        throw new JsonParseException("Entity Type Tag Not Found");
    }

    @Override
    public void toNetwork(class_2540 buffer, AltarRecipe recipe) {
        class_2960 name = class_7923.field_41177.method_10221(recipe.getEntityType());
        if (name == null) {
            throw new JsonParseException("Entity Type Tag Not Found");
        }
        buffer.method_10814(name.toString());
        buffer.method_10794(recipe.getExtraData());
        buffer.writeFloat(recipe.getPowerCost());
        recipe.getCopyInput().method_8088(buffer);
        if (StringUtils.isEmpty(recipe.getCopyTag())) {
            buffer.method_10814("");
        } else {
            buffer.method_10814(recipe.getCopyTag());
        }
        buffer.method_10804(recipe.method_8117().size());
        for (class_1856 input : recipe.method_8117()) {
            input.method_8088(buffer);
        }
    }
}