package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.RangedWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.IMaidMeal;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.meal.MaidMealManager;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_3218;

public class MaidWorkMealTask extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 50;

    public MaidWorkMealTask() {
        super(ImmutableMap.of());
        this.setMaxCheckRate(MAX_DELAY_TIME);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 serverLevel, EntityMaid maid) {
        if (super.checkExtraStartConditions(serverLevel, maid)) {
            String workMealTypeName = Type.WORK_MEAL.getTypeName();
            FavorabilityManager manager = maid.getFavorabilityManager();
            return !maid.method_6113() && maid.getTask().enableEating(maid) && manager.canAdd(workMealTypeName);
        }
        return false;
    }

    @Override
    protected void start(class_3218 serverLevel, EntityMaid maid, long gameTime) {
        List<IMaidMeal> maidMeals = MaidMealManager.getMaidMeals(MaidMealType.WORK_MEAL);

        // 先查询手部的物品能否吃：能就直接开吃，否就进行后续工作
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemInHand = maid.method_5998(hand);

            if (itemInHand.method_7960()) {
                continue;
            }

            for (IMaidMeal maidMeal : maidMeals) {
                if (maidMeal.canMaidEat(maid, itemInHand, hand)) {
                    maidMeal.onMaidEat(maid, itemInHand, hand);
                    return;
                }
            }
        }

        // 对手部进行处理：如果没有空的手部，那就取副手
        class_1268 eanHand = class_1268.field_5810;
        for (class_1268 hand : class_1268.values()) {
            if (maid.method_5998(hand).method_7960()) {
                eanHand = hand;
                break;
            }
        }
        class_1799 itemInHand = maid.method_5998(eanHand);

        // 尝试在背包中寻找食物放入
        boolean hasFood = false;
        RangedWrapper backpackInv = maid.getAvailableBackpackInv();
        swapItemCheck:
        for (int i = 0; i < backpackInv.getSlots(); i++) {
            class_1799 stack = backpackInv.getStackInSlot(i);
            if (stack.method_7960()) {
                continue;
            }
            for (IMaidMeal maidMeal : maidMeals) {
                if (maidMeal.canMaidEat(maid, stack, eanHand)) {
                    class_1799 foodStack = backpackInv.extractItem(i, backpackInv.getStackInSlot(i).method_7947(), false);
                    class_1799 handStack = itemInHand.method_7972();
                    maid.method_6122(eanHand, foodStack);
                    maid.memoryHandItemStack(handStack);
                    itemInHand = maid.method_5998(eanHand);
                    hasFood = true;
                    break swapItemCheck;
                }
            }
        }

        // 开吃
        if (hasFood) {
            for (IMaidMeal maidMeal : maidMeals) {
                if (maidMeal.canMaidEat(maid, itemInHand, eanHand)) {
                    maidMeal.onMaidEat(maid, itemInHand, eanHand);
                    return;
                }
            }
        }
    }
}
