package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidFishedEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskFishing;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1311;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_173;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import java.util.List;

public class MaidFishingHook extends class_1676 {
    public static final class_1299<MaidFishingHook> TYPE = class_1299.class_1300.<MaidFishingHook>method_5903(MaidFishingHook::new, class_1311.field_17715)
            .method_5904().method_5901().method_17687(0.25F, 0.25F)
            .method_27299(4).method_27300(5)
            .method_5905("fishing_hook");
    protected static final class_2940<Boolean> DATA_BITING = class_2945.method_12791(MaidFishingHook.class, class_2943.field_13323);
    protected static final int MAX_OUT_OF_WATER_TIME = 10;
    protected final class_5819 syncronizedRandom = class_5819.method_43047();
    protected final int luck;
    protected final int lureSpeed;
    protected boolean biting;
    protected int nibble;
    protected int timeUntilLured;
    protected int timeUntilHooked;
    protected int outOfWaterTime;
    protected int life;
    protected float fishAngle;
    protected boolean openWater = true;
    protected FishHookState currentState = FishHookState.FLYING;

    protected MaidFishingHook(class_1299<? extends MaidFishingHook> entityType, class_1937 level, int luck, int lureSpeed) {
        super(entityType, level);
        this.field_5985 = true;
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    public MaidFishingHook(class_1299<MaidFishingHook> entityType, class_1937 level) {
        this(entityType, level, 0, 0);
    }

    public MaidFishingHook(EntityMaid maid, class_1937 level, int luck, int lureSpeed, class_243 pos) {
        this(TYPE, level, luck, lureSpeed);
        this.method_7432(maid);
        this.method_29495(pos);
    }

    @Override
    protected void method_5693() {
        this.field_6011.method_12784(DATA_BITING, false);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        if (DATA_BITING.equals(key)) {
            this.biting = this.method_5841().method_12789(DATA_BITING);
            if (this.biting) {
                this.method_18800(this.method_18798().field_1352, -0.4 * class_3532.method_15344(this.syncronizedRandom, 0.6F, 1.0F), this.method_18798().field_1350);
            }
        }
        super.method_5674(key);
    }

    @Override
    public boolean method_5640(double distance) {
        return distance < 64 * 64;
    }


    @Override
    public void method_5759(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport) {
    }

    @Override
    public void method_5773() {
        // 每个 tick 给予不同的 seed，保证随机不一致
        this.syncronizedRandom.method_43052(this.method_5667().getLeastSignificantBits() ^ this.field_6002.method_8510());
        // 父类调用
        super.method_5773();
        // 获取当前钓钩的女仆
        EntityMaid maid = this.getMaidOwner();
        // 女仆为空，那么吊钩也不应当存在
        if (maid == null) {
            this.method_31472();
        } else if (this.field_6002.field_9236 || !this.shouldStopFishing(maid)) {
            if (this.lifeTick()) {
                return;
            }
            maid.method_5988().method_35111(this);
            this.fishingTick();
        }
    }

    protected boolean lifeTick() {
        if (this.method_24828()) {
            // 如果钓钩在地面，最多存在 100 tick 就消失
            ++this.life;
            if (this.life >= 100) {
                this.method_31472();
                return true;
            }
        } else {
            this.life = 0;
        }
        return false;
    }

    protected void fishingTick() {
        // 获取水面高度
        class_2338 blockPos = this.method_24515();
        class_3610 fluidState = this.field_6002.method_8316(blockPos);
        float fluidHeight = this.getFluidHeight(fluidState, blockPos);
        boolean onWaterSurface = fluidHeight > 0;

        if (this.currentState == FishHookState.FLYING) {
            // 如果在水面，那么上下飘动即可
            if (onWaterSurface) {
                this.waterSurfaceTick();
                return;
            }
        } else {
            // 如果已经处于上下飘动状态
            if (this.currentState == FishHookState.BOBBING) {
                // 继续上下飘动
                this.bobbingTick(blockPos, fluidHeight);
                // 开放水域检测，开放水域能够钓到宝藏
                this.checkOpenWater(blockPos);
                // 计算咬钩时的运动和其他逻辑
                if (onWaterSurface) {
                    this.bitingTick(blockPos);
                } else {
                    this.outOfWaterTime = Math.min(MAX_OUT_OF_WATER_TIME, this.outOfWaterTime + 1);
                }
            }
        }

        // 不在水面，那就下坠
        this.fallTick(fluidState);

        // 运动相关更新
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_26962();
        if (this.currentState == FishHookState.FLYING && (this.method_24828() || this.field_5976)) {
            this.method_18799(class_243.field_1353);
        }
        this.method_18799(this.method_18798().method_1021(0.92));
        this.method_23311();
    }

    protected void fallTick(class_3610 fluidState) {
        if (!fluidState.method_15767(class_3486.field_15517)) {
            this.method_18799(this.method_18798().method_1031(0.0D, -0.03D, 0.0D));
        }
    }

    protected void bitingTick(class_2338 blockPos) {
        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
        if (this.biting) {
            this.method_18799(this.method_18798().method_1031(0.0D, -0.1D * (double) this.syncronizedRandom.method_43057() * (double) this.syncronizedRandom.method_43057(), 0.0D));
        }
        // 咬钩！
        if (!this.field_6002.field_9236) {
            this.catchingFish(blockPos, (class_3218) this.field_6002);
        }
    }

    protected void checkOpenWater(class_2338 blockPos) {
        if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
            this.openWater = true;
        } else {
            this.openWater = this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockPos);
        }
    }

    protected float getFluidHeight(class_3610 fluidState, class_2338 blockPos) {
        float fluidHeight = 0;
        if (fluidState.method_15767(class_3486.field_15517)) {
            fluidHeight = fluidState.method_15763(this.method_37908(), blockPos);
        }
        return fluidHeight;
    }

    protected void waterSurfaceTick() {
        this.method_18799(this.method_18798().method_18805(0.3D, 0.2D, 0.3D));
        this.currentState = FishHookState.BOBBING;
    }

    protected void bobbingTick(class_2338 blockPos, float fluidHeight) {
        class_243 movement = this.method_18798();
        double bobbingY = this.method_23318() + movement.field_1351 - (double) blockPos.method_10264() - fluidHeight;
        if (Math.abs(bobbingY) < 0.01D) {
            bobbingY += Math.signum(bobbingY) * 0.1;
        }
        this.method_18800(movement.field_1352 * 0.9, movement.field_1351 - bobbingY * (double) this.field_5974.method_43057() * 0.2, movement.field_1350 * 0.9);
    }

    protected void catchingFish(class_2338 pos, class_3218 level) {
        int time = 1;
        class_2338 abovePos = pos.method_10084();
        // 如果下雨，随机加快钓鱼等待时间
        if (this.field_5974.method_43057() < 0.25F && level.method_8520(abovePos)) {
            ++time;
        }
        // 如果没有露天，减少钓鱼等待时间
        if (this.field_5974.method_43057() < 0.5F && !level.method_8311(abovePos)) {
            --time;
        }
        // 咬钩时间
        if (this.nibble > 0) {
            --this.nibble;
            this.onNibble(level);
        }
        // 如果等待时间
        else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= time;
            // 如果等待时间没结束，那么随机加一点粒子效果
            if (this.timeUntilHooked > 0) {
                // 随机给予运动角度
                this.fishAngle += (float) this.field_5974.method_43385(0.0D, 9.188D);
                float fishAngleRad = this.fishAngle * ((float) Math.PI / 180F);
                float sin = class_3532.method_15374(fishAngleRad);
                float cos = class_3532.method_15362(fishAngleRad);
                double x = this.method_23317() + sin * this.timeUntilHooked * 0.1;
                double y = class_3532.method_15357(this.method_23318()) + 1.0;
                double z = this.method_23321() + cos * this.timeUntilHooked * 0.1;
                class_2680 blockState = level.method_8320(class_2338.method_49637(x, y - 1.0, z));
                // 随机给予钓鱼时出现的水花粒子
                this.spawnFishingParticle(level, blockState, x, y, z, sin, cos);
            } else {
                // 给予咬钩时的粒子效果和音效
                this.spawnNibbleParticle(level);
                // 添加随机的咬钩时间
                this.nibble = class_3532.method_15395(this.field_5974, 20, 40);
                this.method_5841().method_12778(DATA_BITING, true);
            }
        }
        // 计算下一次饵钓时间
        else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= time;
            float probability = 0.15F;
            if (this.timeUntilLured < 20) {
                probability += (float) (20 - this.timeUntilLured) * 0.05F;
            } else if (this.timeUntilLured < 40) {
                probability += (float) (40 - this.timeUntilLured) * 0.02F;
            } else if (this.timeUntilLured < 60) {
                probability += (float) (60 - this.timeUntilLured) * 0.01F;
            }
            // 随机给予粒子效果
            if (this.field_5974.method_43057() < probability) {
                float randomRot = class_3532.method_15344(this.field_5974, 0.0F, 360.0F) * ((float) Math.PI / 180F);
                float randomNum = class_3532.method_15344(this.field_5974, 25.0F, 60.0F);
                double x = this.method_23317() + class_3532.method_15374(randomRot) * randomNum * 0.1;
                double y = class_3532.method_15357(this.method_23318()) + 1.0;
                double z = this.method_23321() + class_3532.method_15362(randomRot) * randomNum * 0.1;
                class_2680 blockState = level.method_8320(class_2338.method_49637(x, y - 1.0, z));
                this.spawnSplashParticle(level, blockState, x, y, z);
            }
            // 饵钓时间到，开始随机赋予等待时间
            if (this.timeUntilLured <= 0) {
                this.fishAngle = class_3532.method_15344(this.field_5974, 0.0F, 360.0F);
                this.timeUntilHooked = class_3532.method_15395(this.field_5974, 20, 80);
            }
        } else {
            this.timeUntilLured = class_3532.method_15395(this.field_5974, 100, 600);
            this.timeUntilLured = this.timeUntilLured - this.lureSpeed;
        }
    }

    protected void spawnSplashParticle(class_3218 level, class_2680 blockState, double x, double y, double z) {
        if (blockState.method_27852(class_2246.field_10382)) {
            level.method_14199(class_2398.field_11202, x, y, z, 2 + this.field_5974.method_43048(2), 0.1F, 0.0D, 0.1F, 0.0D);
        }
    }

    protected void spawnNibbleParticle(class_3218 level) {
        double yOffset = this.method_23318() + 0.5D;
        float bbWidth = this.method_17681();
        this.method_5783(class_3417.field_14660, 0.25F, 1.0F + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.4F);
        level.method_14199(class_2398.field_11247, this.method_23317(), yOffset, this.method_23321(), (int) (1.0F + bbWidth * 20.0F), bbWidth, 0.0D, bbWidth, 0.2F);
        level.method_14199(class_2398.field_11244, this.method_23317(), yOffset, this.method_23321(), (int) (1.0F + bbWidth * 20.0F), bbWidth, 0.0D, bbWidth, 0.2F);
    }

    protected void spawnFishingParticle(class_3218 level, class_2680 blockState, double x, double y, double z, float sin, float cos) {
        if (blockState.method_27852(class_2246.field_10382)) {
            if (this.field_5974.method_43057() < 0.15F) {
                level.method_14199(class_2398.field_11247, x, y - 0.1, z, 1, sin, 0.1D, cos, 0.0D);
            }
            float sinOffset = sin * 0.04F;
            float cosOffset = cos * 0.04F;
            level.method_14199(class_2398.field_11244, x, y, z, 0, cosOffset, 0.01D, -sinOffset, 1.0D);
            level.method_14199(class_2398.field_11244, x, y, z, 0, -cosOffset, 0.01D, sinOffset, 1.0D);
        }
    }

    protected void onNibble(class_3218 level) {
        // 咬钩时间到了，收杆
        EntityMaid maid = getMaidOwner();
        int retrieveTime = class_3532.method_15395(this.field_5974, 2, 10);
        // TODO：收杆应该有成功率，应该和好感度挂钩
        if (this.nibble <= retrieveTime && maid != null) {
            class_1799 rodItem = maid.method_6047();
            int rodDamage = this.retrieve(rodItem);
            this.hurtRod(maid, rodItem, rodDamage);
            maid.method_6104(class_1268.field_5808);
            level.method_43128(null, maid.method_23317(), maid.method_23318(), maid.method_23321(), class_3417.field_15093, class_3419.field_15254, 1.0F, 0.4F / (level.method_8409().method_43057() * 0.4F + 0.8F));
        }
    }

    public int retrieve(class_1799 stack) {
        EntityMaid maid = this.getMaidOwner();
        if (!this.field_6002.field_9236 && maid != null && !this.shouldStopFishing(maid)) {
            MaidFishedEvent event = null;
            MinecraftServer server = this.field_6002.method_8503();
            int rodDamage = 0;

            // 如果是咬钩时间
            if (this.nibble > 0 && server != null) {
                class_3218 serverLevel = (class_3218) this.field_6002;
                class_8567 lootParams = new class_8567.class_8568(serverLevel)
                        .method_51874(class_181.field_24424, this.method_19538())
                        .method_51874(class_181.field_1229, stack)
                        .method_51874(class_181.field_1226, this)
                        // TODO: Fabric没允许这个param
                        // .withParameter(LootContextParams.ATTACKING_ENTITY, maid)
                        .method_51871(this.luck + maid.getLuck())
                        .method_51875(class_173.field_1176);

                List<class_1799> randomItems = this.getLoot(server, lootParams);
                // 添加额外的物品
                this.addExtraLoot(randomItems);

                event = new MaidFishedEvent(randomItems, this.method_24828() ? 2 : 1, this);
                MaidFishedEvent.CALLBACK.invoker().post(event);
                if (event.isCanceled()) {
                    this.method_31472();
                    return event.getRodDamage();
                }

                this.spawnLoot(randomItems, maid);
                // 用于在钓到鱼后施加特殊功能
                this.afterFishing();

                rodDamage = 1;
            }
            if (this.method_24828()) {
                rodDamage = 2;
            }
            this.method_31472();
            return event == null ? rodDamage : event.getRodDamage();
        } else {
            return 0;
        }
    }

    @NotNull
    protected List<class_1799> getLoot(MinecraftServer server, class_8567 lootParams) {
        class_52 lootTable = server.method_3857().getLootTable(class_39.field_353);
        return lootTable.method_51878(lootParams);
    }

    protected void spawnLoot(List<class_1799> randomItems, EntityMaid maid) {
        EntityMaid maidOwner = getMaidOwner();
        class_3222 serverPlayer = null;
        if (maidOwner != null && maidOwner.method_35057() instanceof class_3222 serverPlayerIn) {
            serverPlayer = serverPlayerIn;
        }
        for (class_1799 result : randomItems) {
            if (serverPlayer != null && result.method_31574(class_1802.field_8598)) {
                InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.MAID_FISHING_ENCHANTED_BOOK);
            }
            class_1542 itemEntity = new class_1542(this.method_37908(), maid.method_23317(), maid.method_23318() + 0.5, maid.method_23321(), result);
            itemEntity.method_18800(0, 0.1, 0);
            this.field_6002.method_8649(itemEntity);
            this.field_6002.method_8649(new class_1303(maid.method_37908(), maid.method_23317(), maid.method_23318() + 0.5, maid.method_23321(), this.field_5974.method_43048(6) + 1));
        }
    }

    protected void addExtraLoot(List<class_1799> randomItems) {
    }

    protected void afterFishing() {
        EntityMaid maidOwner = getMaidOwner();
        if (maidOwner != null && maidOwner.method_35057() instanceof class_3222 serverPlayer) {
            InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.MAID_FISHING);
        }
    }

    protected void hurtRod(EntityMaid maid, class_1799 rodItem, int rodDamage) {
        maid.hurtAndBreak(rodItem, rodDamage);
    }

    private boolean calculateOpenWater(class_2338 pos) {
        OpenWaterType openWaterType = OpenWaterType.INVALID;
        for (int y = -1; y <= 2; ++y) {
            OpenWaterType openWaterTypeForArea = this.getOpenWaterTypeForArea(pos.method_10069(-2, y, -2), pos.method_10069(2, y, 2));
            switch (openWaterTypeForArea) {
                case INVALID:
                    return false;
                case ABOVE_WATER:
                    if (openWaterType == OpenWaterType.INVALID) {
                        return false;
                    }
                    break;
                case INSIDE_WATER:
                    if (openWaterType == OpenWaterType.ABOVE_WATER) {
                        return false;
                    }
            }
            openWaterType = openWaterTypeForArea;
        }
        return true;
    }

    private OpenWaterType getOpenWaterTypeForArea(class_2338 firstPos, class_2338 secondPos) {
        return class_2338.method_20437(firstPos, secondPos)
                .map(this::getOpenWaterTypeForBlock)
                .reduce((firstType, secondType) -> firstType == secondType ? firstType : OpenWaterType.INVALID)
                .orElse(OpenWaterType.INVALID);
    }

    private OpenWaterType getOpenWaterTypeForBlock(class_2338 blockPos) {
        class_2680 blockState = this.field_6002.method_8320(blockPos);
        if (!blockState.method_26215() && !blockState.method_27852(class_2246.field_10588)) {
            class_3610 fluidState = blockState.method_26227();
            return fluidState.method_15767(class_3486.field_15517) && fluidState.method_15771()
                    && blockState.method_26220(this.method_37908(), blockPos).method_1110() ? OpenWaterType.INSIDE_WATER : OpenWaterType.INVALID;
        } else {
            return OpenWaterType.ABOVE_WATER;
        }
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    @Override
    protected class_5799 method_33570() {
        return class_5799.field_28630;
    }

    @Override
    public void method_5650(class_5529 reason) {
        this.updateOwnerInfo(null);
        super.method_5650(reason);
    }

    @Override
    public void method_36209() {
        this.updateOwnerInfo(null);
    }

    @Override
    public void method_7432(@Nullable class_1297 owner) {
        super.method_7432(owner);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable MaidFishingHook fishingHook) {
        EntityMaid maid = this.getMaidOwner();
        if (maid != null) {
            maid.fishing = fishingHook;
        }
    }

    @Nullable
    public EntityMaid getMaidOwner() {
        class_1297 entity = this.method_24921();
        return entity instanceof EntityMaid ? (EntityMaid) entity : null;
    }

    private boolean shouldStopFishing(EntityMaid maid) {
        class_1799 mainHandItem = maid.method_6047();
        boolean hasFishingRod = mainHandItem./*canPerformAction(ItemAbilities.FISHING_ROD_CAST)*/method_7909() instanceof class_1787;
        boolean isFishingTask = maid.getTask() instanceof TaskFishing;
        boolean hasVehicle = maid.method_5854() != null;
        if (!maid.method_31481() && maid.method_5805() && hasVehicle && isFishingTask && hasFishingRod && this.method_5858(maid) < 256) {
            return false;
        } else {
            this.method_31472();
            return true;
        }
    }

    @Override
    protected void method_5652(class_2487 compound) {
    }

    @Override
    protected void method_5749(class_2487 compound) {
    }

    @Override
    public boolean method_5822() {
        return false;
    }

    @Override
    public class_2596<class_2602> method_18002() {
        class_1297 entity = this.method_24921();
        return new class_2604(this, entity == null ? this.method_5628() : entity.method_5628());
    }

    @Override
    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (this.getMaidOwner() == null) {
            int dataId = packet.method_11166();
            TouhouLittleMaid.LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", this.field_6002.method_8469(dataId), dataId);
            this.method_5768();
        }
    }

    protected enum FishHookState {
        FLYING,
        BOBBING;
    }

    protected enum OpenWaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;
    }
}
