package com.github.tartaricacid.touhoulittlemaid.item;

import cn.sh1rocu.touhoulittlemaid.api.extension.IItemEntity;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemMaidTooltip;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5632;

public abstract class AbstractStoreMaidItem extends class_1792 implements IItemEntity {
    static final String MAID_INFO = "MaidInfo";
    static final String CUSTOM_NAME = "CustomName";

    public AbstractStoreMaidItem(class_1793 properties) {
        super(properties);
    }

    public static boolean hasMaidData(class_1799 stack) {
        return stack.method_7985() && !Objects.requireNonNull(stack.method_7969()).method_10562(MAID_INFO).method_33133();
    }

    public static class_2487 getMaidData(class_1799 stack) {
        if (hasMaidData(stack)) {
            return Objects.requireNonNull(stack.method_7969()).method_10562(MAID_INFO);
        }
        return new class_2487();
    }

    @Override
    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        if (!entity.method_5851()) {
            entity.method_5834(true);
        }
        if (!entity.method_5655()) {
            entity.method_5684(true);
        }
        class_243 position = entity.method_19538();
        int minY = entity.field_6002.method_31607();
        if (position.field_1351 < minY) {
            entity.method_5875(true);
            entity.method_18799(class_243.field_1353);
            entity.method_5814(position.field_1352, minY, position.field_1350);
        }
        return IItemEntity.super.onEntityItemUpdate(stack, entity);
    }

    @Override
    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2487 maidData = getMaidData(stack);
        if (maidData.method_10573(EntityMaid.MODEL_ID_TAG, class_2520.field_33258)) {
            String modelId = maidData.method_10558(EntityMaid.MODEL_ID_TAG);
            String customName = "";
            if (maidData.method_10573(CUSTOM_NAME, class_2520.field_33258)) {
                customName = maidData.method_10558(CUSTOM_NAME);
            }
            // YSM 渲染相关数据
            YsmMaidInfo ysmMaidInfo = YsmCompat.getYsmMaidInfo(maidData);
            return Optional.of(new ItemMaidTooltip(modelId, customName, ysmMaidInfo));
        }
        return Optional.empty();
    }
}