package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.block.BlockCChess;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class CChessToServerMessage {
    public static final class_2960 ID = getResourceLocation("cchess_to_server");

    public static class_2540 encode(class_2338 pos, int moveFinal, boolean maidLost, boolean playerLostFinal) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.method_10804(moveFinal);
        buf.writeBoolean(maidLost);
        buf.writeBoolean(playerLostFinal);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        class_2338 pos = buf.method_10811();
        int move = buf.method_10816();
        boolean maidLost = buf.readBoolean();
        boolean playerLost = buf.readBoolean();
        server.execute(() -> {
            class_1937 level = player.field_6002;
            if (!level.method_8477(pos)) {
                return;
            }
            BlockCChess.maidMove(player, level, pos, move, maidLost, playerLost);
        });
    }
}
