package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_634;
import java.util.concurrent.CompletableFuture;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class SpawnParticleMessage {
    public static final class_2960 ID = getResourceLocation("spawn_particle");

    public static class_2540 encode(int entityId, Type particleType) {
        return encode(entityId, particleType, 0);
    }

    public static class_2540 encode(int entityId, Type particleType, int delayTicks) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(entityId);
        buf.writeInt(particleType.ordinal());
        buf.method_10804(delayTicks);
        return buf;
    }

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.readInt();
        Type particleType = getTypeByIndex(buf.readInt());
        int delayTicks = buf.method_10816();
        if (delayTicks <= 0) {
            client.execute(() -> handleSpawnParticle(entityId, particleType));
        } else {
            client.execute(() -> CompletableFuture.runAsync(() -> handleSpawnParticleDelay(entityId, particleType, delayTicks), class_156.method_18349()));
        }
    }

    @Environment(EnvType.CLIENT)
    private static void handleSpawnParticleDelay(int entityId, Type particleType, int delayTicks) {
        try {
            Thread.sleep(delayTicks * 50L);
            class_310.method_1551().method_5382(() -> handleSpawnParticle(entityId, particleType));
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Environment(EnvType.CLIENT)
    private static void handleSpawnParticle(int entityId, Type particleType) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_1297 e = mc.field_1687.method_8469(entityId);
        if (e instanceof EntityMaid maid && e.method_5805()) {
            switch (particleType) {
                case EXPLOSION:
                    maid.spawnExplosionParticle();
                    return;
                case BUBBLE:
                    maid.spawnBubbleParticle();
                    return;
                case HEART:
                    maid.spawnHeartParticle();
                    return;
                case RANK_UP:
                    maid.spawnRankUpParticle();
                    return;
                case HEAL:
                    maid.spawnRestoreHealthParticle(maid.method_6051().method_43048(3) + 7);
                    return;
                default:
            }
        }
    }

    private static Type getTypeByIndex(int index) {
        return Type.values()[class_3532.method_15340(index, 0, Type.values().length - 1)];
    }

    public enum Type {
        /**
         * 粒子类型
         */
        EXPLOSION, BUBBLE, HEART, RANK_UP, HEAL
    }
}